package com.yizhi.system.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.system.application.domain.AuthzRoleManager;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 分级授权关联表，该角色可管理以下管理员的业务数据
 * </p>
 *
 * @author shengchenglong
 * @since 2019-02-35
 */
public interface AuthzRoleManagerMapper extends BaseMapper<AuthzRoleManager> {

    /**
     * 批量插入
     *
     * @param list
     * @return
     */
    @Insert("<script>" +
            "insert into authz_role_manager (id, role_id, manager_account_id) " +
            "values " +
            "<foreach collection='list' item='item' separator=','> " +
            "(#{item.id}, #{item.roleId}, #{item.managerAccountId}) " +
            "</foreach>" +
            "</script>")
    int insertBatch(@Param("list") List<AuthzRoleManager> list);

    /**
     * 获取角色下被管理的管理员 id
     *
     * @param siteId
     * @param roleIds
     * @return
     */
    @Select("<script>" +
            "select arm.manager_account_id from authz_role_manager arm " +
            "left join authz_role ar on ar.id = arm.role_id and ar.enabled = 1 " +
            "where ar.site_id = #{siteId} and ar.enabled = 1 " +
            "and ar.id in " +
            "<foreach collection='roleIds' separator=',' item='item' open='(' close=')'>" +
            "#{item}" +
            "</foreach>" +
            "</script>")
    Set<Long> getManagerAccountIdsByRoleIds(@Param("siteId") Long siteId, @Param("roleIds") List<Long> roleIds);

}
