package com.yizhi.system.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.system.application.domain.AuthzRoleMenu;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 * 角色关联模块表，物理删除 Mapper 接口
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-05-16
 */
public interface AuthzRoleMenuMapper extends BaseMapper<AuthzRoleMenu> {

    /**
     * 根据角色id获取模块id
     *
     * @param roleId
     * @return
     */
    List<Long> getIdsByRoleId(@Param("roleId") Long roleId);
    
	/**
	 * 根据角色id列表查看模块id列表
	 * @param roleId
	 * @return
	 */
	@Select("select menu_id  from authz_role_menu where role_id = #{roleId}")
	List<Long> getMenuIdsByRoleId(@Param("roleId") Long roleId);

}
