package com.yizhi.system.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.system.application.domain.AuthzRoleUserGroup;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 角色和管辖区关联表，物理删除 Mapper 接口
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-05-16
 */
public interface AuthzRoleUserGroupMapper extends BaseMapper<AuthzRoleUserGroup> {

    /**
     * 根据角色id查询管辖范围id
     *
     * @param roleIds
     * @return
     */
    List<Long> getUserGroupIdsByRoleIds(@Param("roleIds") List<Long> roleIds);

    /**
     * 根据角色id查询管辖范围id列表
     *
     * @param roleId
     * @return
     */
    @Select("select user_group_id from authz_role_user_group where role_id = #{roleId}")
    List<Long> getUserGroupIdsByRoleId(@Param("roleId") Long roleId);

    /**
     * 根据管辖区id查询角色id
     *
     * @param groupId
     * @return
     */
    @Select("select role_id from authz_role_user_group where user_group_id = #{groupId}")
    Set<Long> getUserIdByGroupId(@Param("groupId") Long groupId);

    @Select("select distinct arug.user_group_id " +
            "from authz_role_user_group arug " +
            "left join authz_role_menu arm on arm.role_id = arug.role_id " +
            "left join authz_account_role aar on aar.role_id = arm.role_id and aar.account_id = #{accountId} and aar.site_id = #{siteId} " +
            "left join authz_menu am on am.id = arm.menu_id and am.code = #{moduleCode} " +
            "where aar.account_id = #{accountId} and am.code = #{moduleCode} and aar.site_id = #{siteId}")
    List<Long> getGroupIdByParam(@Param("accountId") Long accountId, @Param("moduleCode") String moduleCode,
                                 @Param("siteId") Long siteId);
}
