package com.yizhi.system.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.system.application.domain.Organization;
import com.yizhi.system.application.util.RightLeftIndex;
import com.yizhi.system.application.utils.recursion.TreeObjectVO;
import com.yizhi.system.application.vo.OrgExportVO;
import com.yizhi.system.application.vo.ReportOrgRespVO;
import com.yizhi.system.application.vo.practice.AccountOrgVo;

import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 组织部门 Mapper 接口
 * </p>
 *
 * @author fulan123
 * @since 2018-03-08
 */
public interface OrganizationMapper extends BaseMapper<Organization> {

    String SELECT_LAYER_TYPE_PARENT = "parent";
    String SELECT_LAYER_TYPE_CHILD = "child";

    /**
     * 查询重code的部门数量
     *
     * @param id
     * @param companyId
     * @param code
     * @return
     */
    @Select("select count(*)  from organization where "
            + "id <> #{id}  and code = #{code} and company_id= #{companyId} and deleted=0")
    int countExistCodeOrg(@Param(value = "id") Long id, @Param(value = "companyId") Long companyId, @Param(value = "code") String code);

    @Select("SELECT IFNULL(MAX(sort),0) maxSort FROM organization "
            + "WHERE company_id = #{companyId} AND parent_id = #{parentId}")
    int getMaxSort(@Param(value = "companyId") Long companyId, @Param(value = "parentId") Long parentId);

    /**
     * 查询重name的部门数量
     *
     * @param id
     * @param companyId
     * @param name
     * @return
     */
    @Select("select count(*)  from organization where "
            + "id <> #{id} and name = #{name} and company_id= #{companyId} and deleted=0")
    int countExistNameOrg(@Param(value = "id") Long id, @Param(value = "companyId") Long companyId, @Param(value = "name") String name);

    /**
     * 查询企业下的全部组织部门
     *
     * @param companyId
     * @return
     */
    @Select("SELECT id,`name`,parent_id AS parentId FROM organization WHERE deleted=0 AND company_id=#{companyId} ORDER BY parent_id,id")
    List<TreeObjectVO> selectCompanyOrgs(@Param(value = "companyId") long companyId);

    /**
     * 根基id查询
     *
     * @param ids
     * @return
     */
    List<Organization> selectByIds(@Param("ids") List<Long> ids);

    /**
     * 根据角色获取直接关联的部门
     *
     * @param roleId
     * @return
     */
    @Select("select distinct tb.`parent_id_layer` from organization tb " +
            "left join authz_group_member gm on gm.type = 1 and gm.member_id = tb.id " +
            "left join role_user_group rug on rug.user_group_id = gm.group_id and rug.role_id = #{roleId} " +
            "where rug.role_id = #{roleId} and tb.deleted = 0")
    Set<String> getParentIdLayerByRoleId(@Param("roleId") Long roleId);

    /**
     * 查询公司部门数
     *
     * @param companyId
     * @return
     */
    @Select("select count(*)  from organization where company_id= #{companyId} and deleted=0 ")
    int getCountByCompanyId(@Param(value = "companyId") Long companyId);

    /**
     * 查询公司下所有的部门id
     *
     * @param companyId
     * @return
     */
    @Select("select id from organization where company_id= #{companyId} and deleted=0 ")
    Set<Long> getOrgIdsByCompanyId(@Param(value = "companyId") Long companyId);
    
    /**
     * 根据角色ID获取管理的用户
     * @param roleIds
     * @return
     */
    @Select("<script>" +
    		"select distinct tmp.account_id as accountId, acnt.org_id as orgId from ("+
	            "select distinct gm.member_id as account_id "+
	            "FROM authz_group_member gm " +
	            "LEFT JOIN authz_role_user_group rug on rug.user_group_id = gm.group_id  and gm.type = 2 and gm.deleted = 0 " +
	            "WHERE " +
	            "rug.role_id in " +
	            "<foreach collection='roleIds' open='(' close=')' separator=',' item='roleId' index='index'> " +
	            "#{roleId,jdbcType=BIGINT} " +
	            "</foreach>" +
	            ") as tmp "+
            "left join account acnt on tmp.account_id = acnt.id"+
            "</script>")
    List<AccountOrgVo> getUserByRoleId(@Param("roleIds") List<Long> roleIds);

    /**
     * 根据角色id获取管理的组织
     *
     * @param roleIds
     * @return
     */
    @Select("<script>" +
            "SELECT o.id " +
            "FROM organization o " +
            "LEFT JOIN authz_group_member gm on gm.type = 1 and gm.member_id = o.id and gm.deleted = 0" +
            "LEFT JOIN authz_role_user_group rug on rug.user_group_id = gm.group_id " +
            "WHERE " +
            "rug.role_id in" +
            "<foreach collection='roleIds' open='(' close=')' separator=',' item='roleId' index='index'> " +
            "#{roleId,jdbcType=BIGINT} " +
            "</foreach>" +
            "</script>")
    Set<Long> getByRoleId(@Param("roleIds") List<Long> roleIds);

    @Select("<script>" +
            "SELECT a.org_id AS orgId,o.`code` AS orgCode,o.`name` AS orgName, " +
            "count(a.org_id) AS orgAccountNum " +
            "FROM " +
            "account a LEFT JOIN organization o ON a.org_id = o.id " +
            "WHERE 1=1 " +
            "<if test='orgs != null'> " +
            " AND a.org_id IN " +
            "<foreach collection='orgs' open='(' close=')' separator=',' item='orgId' index='index'> " +
            "#{orgId,jdbcType=BIGINT} " +
            "</foreach>" + //<if test="idNumber != null and idNumber != ''">
            "</if>" +
            "<if test='orgName != null'> " +
            "AND o.`name` LIKE #{orgName} " +
            "</if>" +
            "GROUP BY a.org_id " +
            "ORDER BY o.create_time " +
            "</script>")
    List<ReportOrgRespVO> getOrgsCountUserPage(@Param("orgs") List<Long> orgs, @Param("page") Page<ReportOrgRespVO> page, @Param("orgName") String orgName);

    @Select("<script>" +
            "SELECT a.org_id AS orgId,o.`code` AS orgCode,o.`name` AS orgName, " +
            "count(a.org_id) AS orgAccountNum " +
            "FROM " +
            "account a LEFT JOIN organization o ON a.org_id = o.id " +
            "WHERE 1=1 " +
            "<if test='orgs != null'> " +
            " AND a.org_id IN " +
            "<foreach collection='orgs' open='(' close=')' separator=',' item='orgId' index='index'> " +
            "#{orgId,jdbcType=BIGINT} " +
            "</foreach>" + //<if test="idNumber != null and idNumber != ''">
            "</if>" +
            "<if test='orgName != null'> " +
            "AND o.`name` LIKE #{orgName} " +
            "</if>" +
            "GROUP BY a.org_id " +
            "ORDER BY o.create_time " +
            "</script>")
    List<ReportOrgRespVO> getOrgsCountUser(@Param("orgs") List<Long> orgs, @Param("orgName") String orgName);

    /**
     * 获取当前组织的parentIdLayer值
     *
     * @param id
     * @return
     */
    @Select("select parent_id_layer from organization where id = #{id}")
    String getParentIdLayer(@Param("id") Long id);

    /**
     * 根据左右索引和企业id来查询
     *
     * @param companyId
     * @param type      @see com.yizhi.application.mapper.OrganizationMapper#SELECT_LAYER_TYPE_PARENT
     * @param indices
     * @return
     */
    List<Organization> getByIndexAndCompanyId(@Param("companyId") Long companyId, @Param("type") String type, @Param("indices") List<RightLeftIndex> indices);

    /**
     * 根据左右索引和企业id来查询
     *
     * @param companyId
     * @param type      @see com.yizhi.application.mapper.OrganizationMapper#SELECT_LAYER_TYPE_PARENT
     * @param indices
     * @return
     */
    Set<Long> getIdByIndexAndCompanyId(@Param("companyId") Long companyId, @Param("type") String type, @Param("indices") List<RightLeftIndex> indices);

    /**
     * 根据左右索引和企业id来查询
     *
     * @param companyId
     * @param type      @see com.yizhi.application.mapper.OrganizationMapper#SELECT_LAYER_TYPE_PARENT
     * @param indices
     * @return
     */
    List<String> getNamesByIndexAndCompanyId(@Param("companyId") Long companyId, @Param("type") String type, @Param("indices") List<RightLeftIndex> indices);

    /**
     * 查询一个组织下面的所有子部门，（不包含本身）
     *
     * @param left
     * @param right
     * @param companyId
     * @return
     */
    List<Organization> listChildOrg(@Param("left") Integer left, @Param("right") Integer right, @Param("companyId") Long companyId);

    @Update("update organization set " +
            "right_index = right_index + 2, " +
            "left_index = left_index + 2 " +
            "where right_index > #{parentRightIndex} and left_index > #{parentRightIndex}")
    Integer updateIndexAddOneSetpOne(@Param("parentRightIndex") Integer parentRightIndex);

    @Update("update organization set " +
            "right_index = right_index + 2 " +
            "where left_index < #{parentLeftIndex}")
    Integer updateIndexAddOneSetpTwo(@Param("parentLeftIndex") Integer parentLeftIndex);

    @Select("select id from organization where company_id = #{companyId} and deleted = 0")
    List<Long> getIdByCompanyId(@Param("companyId") Long companyId);
    
    List<OrgExportVO> orgExport(@Param("companyId") Long companyId, @Param("orgs") List<Long> orgs);
}
