package com.yizhi.system.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.system.application.domain.SiteProtectNotice;
import com.yizhi.system.application.domain.dto.SiteProtectExportDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface SiteProtectNoticeMapper extends BaseMapper<SiteProtectNotice> {
    /**
     * 查询维护站点通知所有站点的数据
     * @param ids
     * @return
     */
    List<SiteProtectExportDTO> selectExportDataALL(@Param("ids") List<Long> ids);

    /**
     * 查询维护站点通知部分站点的数据
     * @param ids
     * @return
     */
    List<SiteProtectExportDTO> selectExportDataPart(@Param("ids") List<Long> ids);

    List<SiteProtectNotice> selectListByProtectId(@Param("siteProtectId") Long siteProtectId);

	/**
	 * 查询当前生效的关站通知信息
	 * @param id
	 * @return
	 */
	List<SiteProtectNotice> selectValidList(@Param("siteId") Long id);

    List<SiteProtectNotice> selectListEndTimeBeforeCurrent();
}