package com.yizhi.system.application.service;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.system.application.domain.AuthzMenu;
import com.yizhi.system.application.vo.AuthzMenuVo2;
import com.yizhi.system.application.vo.domain.AuthzMenuResponse;
import com.yizhi.util.application.tree.CommonTree;
import com.yizhi.system.application.vo.AuthzMenuVO;

import java.util.List;

/**
 * <p>
 * 模块 服务类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-05-15
 */
public interface IAuthzMenuService extends IService<AuthzMenu> {
    /**
     * 可根据条件进行查询 权限菜单
     *
     * @param name
     * @param integer
     * @param enabled
     * @return
     */
    List<AuthzMenuVo2> queryByCondition(String name, Integer integer, Integer enabled);

    /**
     * 根据id，进行修改
     *
     * @param authzMenu
     * @return
     */
    Boolean updateByAuthzMenu(AuthzMenuVo2 authzMenu);

    /**
     * 根据id，进行逻辑删除
     *
     * @param id
     * @return
     */
    Boolean deleteMenu(Long id);

    /**
     * 添加菜单
     *
     * @param authzMenu
     * @return
     */
    int saveMenu(AuthzMenu authzMenu);

    List <AuthzMenuVo2> getAuthzMenuVOList(String name, Integer enabled,Integer menuType);

    AuthzMenuResponse upOrDown(AuthzMenu authzMenu);

    int sortAuthzMenu(List<AuthzMenu> authzMenus);

    AuthzMenuVo2 getMenuById(Long id);
}
