package com.yizhi.system.application.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.system.application.mapper.AuthzGroupMemberMapper;
import com.yizhi.system.application.mapper.OrganizationMapper;
import com.yizhi.system.application.service.IAuthzGroupMemberService;
import com.yizhi.system.application.service.IOrganizationService;
import com.yizhi.system.application.domain.AuthzGroupMember;
import com.yizhi.system.application.domain.Organization;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 用户组关联用户
 * </p>
 *
 * @author yinyuyan123
 * @since 2018-05-16
 */
@Service
public class AuthzGroupMemberServiceImpl extends ServiceImpl<AuthzGroupMemberMapper, AuthzGroupMember> implements IAuthzGroupMemberService {

    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private IOrganizationService organizationService;

    @Override
    public Set<Long> getMemberIdsByGroupId(Long groupId) {
        return baseMapper.getMemberIdByGroupId(groupId);
    }

    @Override
    public Set<Long> getMemberIdByGroupIdAndType(Long groupId, Integer type) {
        return this.baseMapper.getMemberIdByGroupIdAndType(groupId, type);
    }

    @Override
    public Set<Long> getOrgIdsWithChildByGroupId(Long groupId) {
        Set<Long> orgIds = this.getMemberIdByGroupIdAndType(groupId, 1);
        if (CollectionUtils.isNotEmpty(orgIds)) {
            List<Organization> orgs = organizationMapper.selectBatchIds(orgIds);
            if (CollectionUtils.isNotEmpty(orgIds)) {
                return organizationService.listChildrenId(orgIds);
            }
        }
        return null;
    }
}
