package com.yizhi.system.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.cache.CacheNamespace;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.enums.InternationalEnums;
import com.yizhi.core.application.exception.BizException;
import com.yizhi.system.application.domain.Company;
import com.yizhi.system.application.mapper.AuthzMenuMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.system.application.service.IAuthzMenuService;
import com.yizhi.system.application.domain.AuthzMenu;
import com.yizhi.system.application.service.ICompanyService;
import com.yizhi.system.application.vo.AuthzMenuVo2;
import com.yizhi.system.application.vo.domain.AuthzMenuResponse;
import com.yizhi.util.application.tree.CommonTree;
import com.yizhi.util.application.tree.TreeUtil;
import com.yizhi.system.application.vo.AuthzMenuVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * <p>
 * 模块 服务实现类
 * </p>
 *
 * @author shengchenglong
 * @since 2018-05-15
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class AuthzMenuServiceImpl extends ServiceImpl<AuthzMenuMapper, AuthzMenu> implements IAuthzMenuService {
    private Logger logger = LoggerFactory.getLogger(AuthzMenuServiceImpl.class);

    @Value("${redis.manage.authz.expired}")
    private Long redisManageAuthzExpired;

    @Autowired
    private AuthzMenuMapper authzMenuMapper;

    @Autowired
    private IdGenerator idGenerator;
    @Autowired
    private RedisCache redisCache;
    @Autowired
    private ICompanyService iCompanyService;



    @Override
    public List<AuthzMenuVo2> queryByCondition(String name, Integer enabled, Integer type) {
        List<AuthzMenu> list = this.authzMenuMapper.queryByCondition(name, enabled, type);
        List<AuthzMenuVo2> list1=new ArrayList<>();
        for (AuthzMenu a:list
             ) {
            com.yizhi.system.application.vo.domain.AuthzMenu authzMenuVo = new com.yizhi.system.application.vo.domain.AuthzMenu();
            BeanUtils.copyProperties(a,authzMenuVo);
            AuthzMenuVo2 a2=new AuthzMenuVo2(authzMenuVo);
            list1.add(a2);
        }
        //  菜单排序
        return buildTree(list1);
    }

    /**
     * 暂停使用
     * @param name
     * @param enabled
     * @param menuType
     * @return
     */
    @Override
    public List<AuthzMenuVo2> getAuthzMenuVOList(String name, Integer enabled, Integer menuType) {
        List<AuthzMenu> domainList = this.authzMenuMapper.queryByCondition(name, enabled, menuType);
        List<com.yizhi.system.application.vo.domain.AuthzMenu> list = new ArrayList<>();
        domainList.forEach(authzMenu -> {
            com.yizhi.system.application.vo.domain.AuthzMenu authzMenu1 = new com.yizhi.system.application.vo.domain.AuthzMenu();
            BeanUtils.copyProperties(authzMenu,authzMenu1);
            list.add(authzMenu1);
        });
        List<AuthzMenuVo2> topList = new ArrayList<>();
        for (com.yizhi.system.application.vo.domain.AuthzMenu m : list) {
            AuthzMenuVo2 authzMenuVO = new AuthzMenuVo2(m);
            topList.add(authzMenuVO);
        }
        for (AuthzMenuVo2 vo : topList) {
            List<AuthzMenuVo2> childrenList = new ArrayList<>();
            for (com.yizhi.system.application.vo.domain.AuthzMenu m : list) {
                AuthzMenuVo2 authzMenuVO = null;
                if (vo.getId() == m.getParentId()) {
                    authzMenuVO=new AuthzMenuVo2(m);
                    childrenList.add(authzMenuVO);
                }
            }
            vo.setChildrenMenus(childrenList);
        }
        return topList;
    }

    @Override
    public AuthzMenuVo2 getMenuById(Long id) {
        if (id == null) {
            throw new BizException("212000", InternationalEnums.AUTHZMENUCONTROLLER3.getCode());
        }
        AuthzMenu authzMenu = null;
        EntityWrapper<AuthzMenu> entity = new EntityWrapper<>();
        entity.eq("id", id).and().eq("deleted", 0);
        authzMenu = selectOne(entity);
        if (authzMenu == null) {
            throw new BizException("212000", InternationalEnums.AUTHZMENUCONTROLLER4.getCode());
        }
        com.yizhi.system.application.vo.domain.AuthzMenu authzMenuVo = new com.yizhi.system.application.vo.domain.AuthzMenu();
        BeanUtils.copyProperties(authzMenu,authzMenuVo);
        AuthzMenuVo2 authzMenuVo2 = new AuthzMenuVo2(authzMenuVo);
        authzMenuVo2.setMenuLevel(getMenuLevel(authzMenu.getParentIdLayer()));
        return authzMenuVo2;
    }

    @Override
    public Boolean updateByAuthzMenu(AuthzMenuVo2 authzMenuVo2) {
        AuthzMenu authzMenu = new AuthzMenu(authzMenuVo2);
        if (authzMenu == null) {
            throw new BizException("212000", InternationalEnums.AUTHZMENUCONTROLLER5.getCode());
        }
        if (!authzMenu.getDescription().isEmpty() && authzMenu.getDescription().length() > 50) {
            throw new BizException("212005", InternationalEnums.AUTHZMENUCONTROLLER25.getCode());
        }
        AuthzMenu old = authzMenu.selectById();
        boolean flag = count(authzMenuVo2.getName());
        if (!flag){
            throw new BizException("212006",InternationalEnums.AUTHZMENUCONTROLLER11.getCode());
        }
        if (null == old) {
            throw new BizException("212001", InternationalEnums.AUTHZMENUCONTROLLER4.getCode());
        }
        AuthzMenu authzMenuParent = selectById(authzMenuVo2.getParentId());
        if (authzMenuParent == null) {
            throw new BizException("23002", InternationalEnums.AUTHZMENUCONTROLLER22.getCode());
        }
        if (authzMenuParent.getMenuType() != 0) {
            throw new BizException("230002", InternationalEnums.AUTHZMENUCONTROLLER24.getCode());
        }
        int pMenuLevel = getMenuLevel(authzMenuParent.getParentIdLayer());
        if (authzMenu.getMenuType() == 2 && pMenuLevel != 2) {
            throw new BizException("212002", InternationalEnums.AUTHZMENUCONTROLLER6.getCode());
        }
        if (authzMenu.getMenuType() == 0 && pMenuLevel >= 2) {
            throw new BizException("212003", InternationalEnums.AUTHZMENUCONTROLLER7.getCode());
        }
        if (!old.getName().equals(authzMenu.getName())){
            //判断同一父级菜单下有没有同名的菜单
            if (nameIsRepeated(authzMenu)){
                throw new BizException("212004",InternationalEnums.AUTHZMENUCONTROLLER12.getCode());
            }
        }
        //判断原来菜单有没有子菜单 子菜单的最大层级
        EntityWrapper<AuthzMenu> entity = new EntityWrapper<>();
        entity.eq("parent_id", authzMenu.getId());
        entity.eq("deleted",0);
        List<AuthzMenu> list = selectList(entity);
        int maxLevel = 1;
        if (!CollectionUtils.isEmpty(list)) {
            maxLevel = getMaxLevel(list) - authzMenuVo2.getMenuLevel() + 1;
        }
        if (maxLevel + pMenuLevel > 3) {
            throw new BizException("212004", InternationalEnums.AUTHZMENUCONTROLLER8.getCode());
        }
        RequestContext context = ContextHolder.get();
        //修改顶层的 parentlayer
        getParentLayer(authzMenu);
        authzMenu.setMenuType(old.getMenuType());
        //只有修改了上级菜单 才会重新排序
        if (old.getParentId() != authzMenu.getParentId()) {
            authzMenu.setSort(maxSort(authzMenu.getParentId()) == null ? 1 : maxSort(authzMenu.getParentId()) + 1);
        }
        authzMenu.setUpdateByName(context.getAccountName());
        authzMenu.setUpdateById(context.getAccountId());
        if (!authzMenu.updateById()) {
            return false;
        }
        //修改信息
        for (AuthzMenu m : list
        ) {
            m.setUpdateByName(context.getAccountName());
            m.setUpdateById(context.getAccountId());
            getParentLayer(m);
            m.updateById();
        }
        RequestContext requestContext=ContextHolder.get();
        // 更新redis中的内容
        deletedAllMenu();
//        redisCache.delete(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ACCOUNT_ACCESS_SITE + requestContext.getCompanyCode());
        return true;
    }

    @Override
    public Boolean deleteMenu(Long id) {
        if (id == null) {
            throw new BizException("212002", InternationalEnums.AUTHZMENUCONTROLLER3.getCode());
        }
        AuthzMenu authzMenu = selectById(id);
        if (authzMenu == null) {
            throw new BizException("212000", InternationalEnums.AUTHZMENUCONTROLLER4.getCode());
        }
        RequestContext context = ContextHolder.get();
        authzMenu.setUpdateByName(context.getAccountName());
        authzMenu.setUpdateById(context.getAccountId());
        if (authzMenu.getMenuType() == 1) {
            EntityWrapper<AuthzMenu> entityWrapper = new EntityWrapper<>();
            entityWrapper.eq("parent_id", authzMenu.getId());
            List<AuthzMenu> authzMenus = selectList(entityWrapper);
            if (!CollectionUtils.isEmpty(authzMenus)) {
                throw new BizException("212005", InternationalEnums.AUTHZMENUCONTROLLER9.getCode());
            }
        }
        authzMenu.setDeleted(1);
        int i = this.authzMenuMapper.updateById(authzMenu);
        if (i == 1) {
            RequestContext requestContext=ContextHolder.get();
            // 更新redis中的内容
            deletedAllMenu();
//            redisCache.delete(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ACCOUNT_ACCESS_SITE + requestContext.getCompanyCode());

            return true;
        }
        return false;

    }



    @Override
    public int saveMenu(AuthzMenu authzMenu) {
        RequestContext requestContext = ContextHolder.get();
        if (authzMenu == null) {
            throw new BizException("212002", InternationalEnums.AUTHZMENUCONTROLLER10.getCode());
        }
        Boolean flag = count(authzMenu.getName());
        if (!flag) {
            logger.error(InternationalEnums.AUTHZMENUCONTROLLER11.getCode());
            return 0;
        }
        if (!authzMenu.getDescription().isEmpty() && authzMenu.getDescription().length() > 50) {
            throw new BizException("212005", InternationalEnums.AUTHZMENUCONTROLLER25.getCode());
        }

        //判断同一父级菜单下是否有同名菜单
        if (nameIsRepeated(authzMenu)) return 3;

        AuthzMenu authzMenuParent = selectById(authzMenu.getParentId());
        if (authzMenuParent == null) {
            throw new BizException("23002", InternationalEnums.AUTHZMENUCONTROLLER22.getCode());
        }
        if ((authzMenu.getMenuType() == 0 || authzMenu.getMenuType() == 2) && authzMenu.getUrl() != null) {
            throw new BizException("23004", InternationalEnums.AUTHZMENUCONTROLLER23.getCode());
        }
        int menuLevel = getMenuLevel(authzMenuParent.getParentIdLayer()) + 1;
        if (menuLevel > 3) {//超过了三级菜单
            logger.error(InternationalEnums.AUTHZMENUCONTROLLER13.getCode());
            return 2;
        }
        if (menuLevel == 1 && authzMenu.getMenuType() == 2
                || menuLevel == 3 && authzMenu.getMenuType() != 1) {
            logger.error(InternationalEnums.AUTHZMENUCONTROLLER14.getCode());
            return 4;
        }

        Integer maxSort = maxSort(authzMenu.getParentId());
        if (maxSort == null) {
            authzMenu.setSort(1);
        } else {
            authzMenu.setSort(maxSort + 1);
        }
        if (authzMenu.getParentId() == null) {
            authzMenu.setParentId(0L);
        }
        authzMenu.setId(idGenerator.generate());
        authzMenu.setCreateById(requestContext.getAccountId());
        authzMenu.setCreateByName(requestContext.getAccountName());
        authzMenu.setCreateTime(new Date());
        if (authzMenu.getType()!=null && (authzMenu.getType()>3||authzMenu.getType()<1)){
            throw new BizException("212009", InternationalEnums.AUTHZMENUCONTROLLER15.getCode());
        }

        getParentLayer(authzMenu);
        if (authzMenu.insert()) {
            //生成国际化key
            String key = this.authzMenuMapper.getInternationalKey(authzMenu.getId());
            authzMenu.setInternationalKey(key);
            authzMenu.updateById();
            //调用 接口 将国际化键值 插入到相应表中

            // 更新redis中的内容
            deletedAllMenu();
//            redisCache.delete(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ACCOUNT_ACCESS_SITE + requestContext.getCompanyCode());

            return 1;
        }
        return 0;
    }

    private boolean nameIsRepeated(AuthzMenu authzMenu) {
        EntityWrapper<AuthzMenu> entity = new EntityWrapper<>();
        entity.eq("name", authzMenu.getName());
        entity.eq("deleted",0);
        entity.eq("parent_id",authzMenu.getParentId());

        AuthzMenu authzMenu1 = selectOne(entity);
        if (authzMenu1 != null) {
            logger.error(InternationalEnums.AUTHZMENUCONTROLLER12.getCode());
            return true;
        }
        return false;
    }

    @Override
    public AuthzMenuResponse upOrDown(AuthzMenu authzMenu) {
        AuthzMenuResponse authzMenuResponse = new AuthzMenuResponse();
        Integer enable = authzMenu.getEnabled();
        if (enable == null) {
            throw new BizException("23000", InternationalEnums.AUTHZMENUCONTROLLER16.getCode());
        }
        authzMenu = authzMenu.selectById();
        if (authzMenu == null) {
            authzMenuResponse.setCode("fail");
            authzMenuResponse.setMsg(InternationalEnums.AUTHZMENUCONTROLLER17.getCode());
            return authzMenuResponse;
        }

        deletedAllMenu();
        if (1 == enable) {
            authzMenu.setEnabled(1);
            RequestContext context = ContextHolder.get();
            authzMenu.setUpdateByName(context.getAccountName());
            authzMenu.setUpdateById(context.getAccountId());
            if (authzMenu.updateById()) {
                authzMenuResponse.setCode("success");
                authzMenuResponse.setMsg("");
                RequestContext requestContext=ContextHolder.get();
                // 更新redis中的内容
//                redisCache.delete(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ACCOUNT_ACCESS_SITE + requestContext.getCompanyCode());
                return authzMenuResponse;
            } else {
                authzMenuResponse.setCode("fail");
                authzMenuResponse.setMsg(InternationalEnums.AUTHZMENUCONTROLLER18.getCode());
                return authzMenuResponse;
            }
        } else if (0 == enable) {
            //禁用
            authzMenu.setEnabled(0);
            if (authzMenu.updateById()) {
                authzMenuResponse.setCode("success");
                authzMenuResponse.setMsg("");
                RequestContext requestContext=ContextHolder.get();
                // 更新redis中的内容
//                redisCache.delete(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ACCOUNT_ACCESS_SITE + requestContext.getCompanyCode());
                return authzMenuResponse;
            }
            authzMenuResponse.setCode("fail");
            authzMenuResponse.setMsg(InternationalEnums.AUTHZMENUCONTROLLER18.getCode());
            return authzMenuResponse;
        } else {
            authzMenuResponse.setCode("fail");
            authzMenuResponse.setMsg(InternationalEnums.AUTHZMENUCONTROLLER20.getCode());
            return authzMenuResponse;
        }
    }

    @Override
    public int sortAuthzMenu(List<AuthzMenu> authzMenus) {
        RequestContext context = ContextHolder.get();
        if (CollectionUtils.isEmpty(authzMenus)) {
            return 0;
        }
        if (authzMenus.size() == 2) {
            AuthzMenu authzMenuFirst = authzMenus.get(0);
            AuthzMenu authzMenuLast = authzMenus.get(1);
            long fpid=authzMenuFirst.getParentId();
            long lpid=authzMenuLast.getParentId();
            if (fpid!=lpid){
                throw new BizException("243000",InternationalEnums.AUTHZMENUCONTROLLER26.getCode());
            }
            int maxSort=maxSort(authzMenuFirst.getParentId());
            if (authzMenuFirst.getSort()<1){
                throw new BizException("243000",InternationalEnums.AUTHZMENUCONTROLLER27.getCode());

            }
            if (authzMenuLast.getSort()>maxSort){
                throw new BizException("243001",InternationalEnums.AUTHZMENUCONTROLLER28.getCode());
            }
            if (authzMenuFirst.getSort().equals(authzMenuLast.getSort())) {
                authzMenuLast.setSort(authzMenuFirst.getSort() + 1);
            }
            RequestContext requestContext=ContextHolder.get();

            authzMenuFirst.setUpdateById(context.getAccountId());
            authzMenuFirst.setUpdateByName(context.getAccountName());
            authzMenuLast.setUpdateById(context.getAccountId());
            authzMenuLast.setUpdateByName(context.getAccountName());
            updateById(authzMenuFirst);
            updateById(authzMenuLast);
            // 更新redis中的内容
            deletedAllMenu();
//            redisCache.delete(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ACCOUNT_ACCESS_SITE + requestContext.getCompanyCode());

        }
        return 1;
    }

    private void getParentLayer(AuthzMenu authzMenu) {
        AuthzMenu authzMenuParent = selectById(authzMenu.getParentId());
        StringBuffer sb = new StringBuffer();
        authzMenu.setParentIdLayer(sb.append(authzMenuParent.getParentIdLayer()).append("_").append(authzMenu.getId()).toString());
        if (authzMenu.getParentId() == 0) {
            authzMenu.setParentIdLayer(authzMenu.getId().toString());
        }
    }

    //查到母菜单下 子菜单的最大层级
    private int getMaxLevel(List<AuthzMenu> list) {
        int maxLevel=2;
        for (AuthzMenu authzMenu1 : list
        ) {
            EntityWrapper<AuthzMenu> entity = new EntityWrapper<>();
            entity.eq("parent_id", authzMenu1.getId());
            entity.eq("deleted",0);
            List<AuthzMenu> list1 = selectList(entity);
            if (!CollectionUtils.isEmpty(list1)){
                maxLevel=3;
            }
        }
        return maxLevel;
    }

    /***
     　　* 统计字符串中中文，英文，数字，空格等字符个数
     * 最长11个中文字或20个英文字包括空格。
     　　* @param str 需要统计的字符串
     　　*/
    public Boolean count(String str) {
        int enCharacter = 0, spaceCharacter = 0, chCharacter = 0;
        if (str == null || "".equals(str) || str.length() > 20) {
            logger.error(InternationalEnums.AUTHZMENUCONTROLLER21.getCode());
            return false;
        }
        for (int i = 0; i < str.length(); i++) {
            char tmp = str.charAt(i);
            if ((tmp >= 'A' && tmp <= 'Z') || (tmp >= 'a' && tmp <= 'z')) {
                enCharacter++;
            } else if (tmp == ' ') {
                spaceCharacter++;
            } else if (isChinese(tmp)) {
                chCharacter++;
            }
        }
        if (spaceCharacter + enCharacter > 20 ||
                spaceCharacter + chCharacter > 11) {
            return false;
        }
        return true;
    }

    Integer maxSort(Long id) {
        return authzMenuMapper.maxSort(id);
    }

    /**
     * 　　 * 判断字符是否为中文
     * 　　 * @param ch 需要判断的字符
     * 　　 * @return 中文返回true，非中文返回false
     */
    private boolean isChinese(char ch) {
        //获取此字符的UniCodeBlock
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(ch);
        // GENERAL_PUNCTUATION 判断中文的“号
        // CJK_SYMBOLS_AND_PUNCTUATION 判断中文的。号

        if (ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS
                ||
                ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B ||
                ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS
                || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION) {
            return true;
        }
        return false;
    }

    /**
     * 返回当前菜单级别
     *
     * @param parentIdLayer
     * @return
     */
    private Integer getMenuLevel(String parentIdLayer) {
        if (parentIdLayer == null || "-1".equals(parentIdLayer)) {
            return 0;
        }
        String[] strings = parentIdLayer.split("_");
        return strings.length;
    }

    private List<AuthzMenuVo2> buildTree(List<AuthzMenuVo2> authzMenus) {
        Set<Long> menuIds = new HashSet<>();
        for (AuthzMenuVo2 authzMenu : authzMenus) {
            menuIds.add(authzMenu.getId());
        }

        if (!CollectionUtils.isEmpty(menuIds)) {
            List<AuthzMenu> menus = authzMenuMapper.selectBatchIds(menuIds);
            if (!CollectionUtils.isEmpty(menus)) {
                for (AuthzMenu menu : menus) {
                    String parentIdLayer = menu.getParentIdLayer();
                    if (!StringUtils.isEmpty(parentIdLayer)) {
                        String[] ids = parentIdLayer.split("_");
                        if (ids.length > 0) {
                            for (String id : ids) {
                                menuIds.add(Long.valueOf(id));
                            }
                        }
                    }
                }
            }

            List<AuthzMenu> realMenus = authzMenuMapper.selectBatchIds(menuIds);
            List<AuthzMenuVo2> menuTrees = new ArrayList<>();
            for (AuthzMenu a:realMenus
            ) {
                com.yizhi.system.application.vo.domain.AuthzMenu authzMenuVo = new com.yizhi.system.application.vo.domain.AuthzMenu();
                BeanUtils.copyProperties(a,authzMenuVo);
                AuthzMenuVo2 a2=new AuthzMenuVo2(authzMenuVo);
                a2.setMenuLevel(getMenuLevel(a.getParentIdLayer()));
                menuTrees.add(a2);
            }
            menuTrees = treeList(menuTrees, 0L);
            return menuTrees;
        }
        return new ArrayList<>();
    }

    /**
     * 获得一个树形菜单
     *
     * @param originList
     * @return
     */
    public List<AuthzMenuVo2> treeList(List<AuthzMenuVo2> originList, Object topKey) {
        List<AuthzMenuVo2> list = new ArrayList<AuthzMenuVo2>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(originList)) {
            for (AuthzMenuVo2 x : originList) {
                if (null != x) {
                    if (x.getParentId().equals(topKey)) {
                        x.setChildrenMenus(treeChild(originList, x));
                        list.add(x);
                    }
                }
            }
        }
        Collections.sort(list);

        return list;
    }
    /**
     * 获得子节点
     *
     * @param treeList
     * @param parent
     * @return
     */
    public List<AuthzMenuVo2> treeChild(List<AuthzMenuVo2> treeList, AuthzMenuVo2 parent) {
        List<AuthzMenuVo2> tempList = new ArrayList<>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(treeList)) {
            for (AuthzMenuVo2 a : treeList) {
                if (null != a) {
                    if (a.getParentId().equals(parent.getId())) {
                        a.setChildrenMenus(treeChild(treeList, a));
                        a.setParentName(parent.getName());
                        tempList.add(a);
                    }
                }
            }
        }
        Collections.sort(tempList);
        return tempList;
    }


    public void deletedAllMenu() {
        List<Company> list = iCompanyService.findAllCompany();
        if (list == null || list.isEmpty()) {
            return;
        }
        list.parallelStream().forEach(c -> {
            redisCache.delete(CacheNamespace.REDIS_AUTHZ_MANAGE_COMPANY_ACCOUNT_ACCESS_SITE + c.getCode());
        });
    }
}
