package com.yizhi.system.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.core.application.cache.RedisCache;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.task.AbstractTaskHandler;
import com.yizhi.core.application.task.TaskExecutor;
import com.yizhi.system.application.constant.TerminalType;
import com.yizhi.system.application.domain.FirstLoginLog;
import com.yizhi.system.application.mapper.FirstLoginLogMapper;
import com.yizhi.system.application.service.IFirstLoginLogService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author taoge123
 * @since 2020-12-30
 */
@Service
@Slf4j
public class FirstLoginLogServiceImpl extends ServiceImpl<FirstLoginLogMapper, FirstLoginLog> implements IFirstLoginLogService {
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private FirstLoginLogMapper firstLoginLogMapper;
    @Autowired
    private RedisCache redisCache;


    @Override
    public Boolean saveFirstLoginLog(String terminalType, String loginType) {
        RequestContext context = ContextHolder.get();

        if (!context.getSiteCode().equals("essc") && !context.getCompanyCode().equals("ebscn")) {
            return false;
            // TODO: 2020/12/30 任务1484暂时为只记录光大站点
        }
        if (!TerminalType.PC.equals(terminalType) && !TerminalType.H5.equals(terminalType)) {
            log.info("终端类型不合理！！！");
            return false;
            // TODO: 2020/12/30 任务1484暂时为只记录pc h5
        }
        String key = "first_login_accountId:" + context.getAccountId() + "terminal:" + terminalType;
        if (redisCache.exists(key)) {
            return false;
        }
        FirstLoginLog firstLoginLog = new FirstLoginLog();
        firstLoginLog.setSiteId(context.getSiteId());
        firstLoginLog.setAccountId(context.getAccountId());
        firstLoginLog.setTerminalType(terminalType);
        Integer result = firstLoginLogMapper.selectCount(new EntityWrapper<>(firstLoginLog));
        if (result == 0) {
            taskExecutor.asynExecute(new AbstractTaskHandler() {
                @Override
                public void handle() {
                    firstLoginLog.setCompanyId(context.getCompanyId());
                    firstLoginLog.setLoginType(loginType);
                    firstLoginLog.setOrgId(context.getOrgId());
                    firstLoginLogMapper.insert(firstLoginLog);
                    log.info("光大站点学员首次登录，id：" + context.getAccountId());
                    //缓存设置为1个礼拜
                    redisCache.set(key, "1", 3600 * 24 * 7);
                }
            });
            return true;
        }
        //缓存设置为1个礼拜
        redisCache.set(key, "1", 3600 * 24 * 7);
        return false;
    }
}
