package com.yizhi.system.application.service.impl;

import java.util.List;

import com.yizhi.system.application.domain.LanguageWord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.system.application.mapper.LanguageClassifyMapper;
import com.yizhi.system.application.mapper.LanguageTranslationMapper;
import com.yizhi.system.application.mapper.LanguageWordMapper;
import com.yizhi.system.application.service.LanguageWordService;
import com.yizhi.system.application.vo.LanguageVo;

@Service
public class LanguageWordServiceImpl extends ServiceImpl<LanguageWordMapper, LanguageWord> implements LanguageWordService{
	
    @Value("${ACTIVE}")
    public String active;
	
    @Autowired
    private LanguageClassifyMapper languageClassifyMapper;
    
    @Autowired
    private LanguageWordMapper languageWordMapper;
    
    @Autowired
    private LanguageTranslationMapper languageTranslationMapper;
    
	private static final Logger logger = LoggerFactory.getLogger(LanguageWordServiceImpl.class);

	@Override
	public Boolean checkKey(String key,Integer type) {
		// TODO Auto-generated method stub
		LanguageWord word = new LanguageWord();
		word.setKey(key);
		word.setType(type);
		int count = word.selectCount(new EntityWrapper<LanguageWord>(word));
		if (count>0) {
			return Boolean.FALSE;
		}
		return Boolean.TRUE;
	}

	@Override
	public Page<LanguageVo> page(Long classifyId, Integer type, Integer state, String kwd, Integer pageNo,
			Integer pageSize) {
		Page<LanguageVo> page = new Page<LanguageVo>(pageNo, pageSize);
		List<LanguageVo> list = languageWordMapper.page(classifyId, type, kwd, state, page);
		page.setRecords(list);
		return page;
	}

	@Override
	public List<LanguageVo> list(Long classifyId, Integer type, Integer state, String kwd) {
		// TODO Auto-generated method stub
		return languageWordMapper.list(classifyId, type, kwd, state);
	}

}
