package com.yizhi.system.application.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.plugins.pagination.PageHelper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.system.application.mapper.LoginLogMapper;
import com.yizhi.system.application.service.IAccountService;
import com.yizhi.system.application.service.ILoginExportService;
import com.yizhi.system.application.domain.LoginLog;
import com.yizhi.system.application.vo.LoginDataStatisticsVO;
import com.yizhi.system.application.vo.LoginUserChartVO;
import com.yizhi.system.application.vo.LoginUserExportVO;
import com.yizhi.system.application.vo.LoginUserOrgExportVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @Author: XieHaijun
 * @Description:
 * @Date: Created in 19:58 2018/8/28
 * @Modified By
 */
@Service
public class LoginExportServiceImpl extends ServiceImpl<LoginLogMapper, LoginLog> implements ILoginExportService {

    private static Logger logger = LoggerFactory.getLogger(LoginExportServiceImpl.class);

    private static final String SPILT_STR = ",";

    @Autowired
    private IAccountService accountService;

    /**
     * 获取登陆情况的图表数据
     *
     * @param startDate
     * @param endDate
     * @param type
     * @param cid
     * @param siteId
     * @param orgs      @return
     */
    @Override
    public List<LoginUserChartVO> loginLogChart(String startDate, String endDate, Integer type, Long cid, Long siteId, List<Long> orgs) {
        Page<LoginUserChartVO> pageData = new Page<>();
        // 开始时间
        LocalDate startLocalDate = LocalDate.parse(startDate, DateTimeFormatter.ISO_DATE);
        // 结束时间
        LocalDate endLocalDate = LocalDate.parse(endDate, DateTimeFormatter.ISO_DATE);

        List<String> retDataKey = getStringStream(type, startLocalDate, endLocalDate);
        logger.info("****************统计图表出来的时间信息={}", JSON.toJSONString(retDataKey));
        endDate = endDate+" 23:59:59";

        List<LoginUserChartVO> ret = this.baseMapper.loginLogChart(startDate,
                endDate, type, cid, siteId, orgs);

        Map<String,LoginUserChartVO> LonginData = null;

        List<LoginUserChartVO> retData = new ArrayList<>();

        if(!CollectionUtils.isEmpty(ret)){
            // 获取分享的次数
            LonginData = ret.stream().parallel().collect(Collectors.toMap(key->key.getDateStr(),val->val));
            boolean isSpilt = false;
            if(type != null && type==2){
                isSpilt = true;
            }
            for(String key : retDataKey){
                String viewkey = key;
                if(isSpilt){
                    String[] keys=key.split(SPILT_STR);
                    key = keys[0];
                    viewkey = keys[1];
                }
                LoginUserChartVO obj = LonginData.get(key);

                if(obj == null){
                    obj = new LoginUserChartVO();
                    obj.setDateStr(viewkey);
                    obj.setLoginNum(0L);
                    obj.setLoginVisit(0L);
                }else {
                    obj.setDateStr(viewkey);
                }
                retData.add(obj);
            }
        }

        return retData;
    }

    /**
     * 根据组织获取登陆情况
     *
     * @param startDate
     * @param endDate
     * @param kwd
     * @param pageSize
     * @param pageNo
     * @param cid
     * @param siteId
     * @param orgs      @return
     */
    @Override
    public Page<LoginUserOrgExportVO> loginLogByOrg(String startDate, String endDate, String kwd,
                                                    Integer pageSize, Integer pageNo,
                                                    Long cid, Long siteId, List<Long> orgs) {

        Page<LoginUserOrgExportVO> retData = new Page<>();
        // 查询部门列表
        endDate = endDate+" 23:59:59";
        if(StringUtils.isNotBlank(kwd)){
            kwd="%"+kwd+"%";
        }else {
            kwd =null;
        }
        // 开始分页
        logger.info("分页信息pageSize={},pageNo={}",pageSize,pageNo);
        if(pageSize != null && pageNo != null){
            PageHelper.startPage(pageNo,pageSize);
        }
        // 查询组织的分页列表
        List<LoginUserOrgExportVO> orgInfoList = this.baseMapper.orgGroup(kwd,cid,siteId,orgs);
        if(pageSize != null && pageNo != null){

            retData.setTotal(PageHelper.getTotal());
            retData.setSize(pageSize);
            retData.setCurrent(pageNo);
            PageHelper.remove();
        }
        if(!CollectionUtils.isEmpty(orgInfoList)){
            List<LoginUserOrgExportVO> recodData = new ArrayList<>();

            // 查询统计登陆的组织信息（分组数据）
            List<LoginUserOrgExportVO> orgLoginInfoList = this.baseMapper.loginLogByOrg
                    (startDate,endDate,cid,siteId,orgs);

            boolean isDiff = CollectionUtils.isEmpty(orgLoginInfoList);
            Map<Long,LoginUserOrgExportVO> diffData = null;
            if(!isDiff){
                diffData = orgLoginInfoList.stream().collect(Collectors.toMap(e->e.getOrgId(),e->e));
                logger.info("************%%%%%%%%%#########******************************根据部门统计出来的登陆信息="+JSON.toJSONString(diffData));
            }

            Map<Long,List<LoginUserOrgExportVO>> tempData =
                    orgInfoList.stream().collect(Collectors.groupingBy(LoginUserOrgExportVO::getOrgId));

            for(Map.Entry<Long, List<LoginUserOrgExportVO>> item : tempData.entrySet()){
                LoginUserOrgExportVO vo = item.getValue().get(0);
                Long key = item.getKey();
                Map<String,LongSummaryStatistics> activitUserNum = item.getValue().stream()
                        .collect(Collectors.groupingBy(LoginUserOrgExportVO::getStatus,
                                Collectors.summarizingLong(LoginUserOrgExportVO::getUserSumNum)));
                Set<Map.Entry<String,LongSummaryStatistics>> objItem = activitUserNum.entrySet();
                Long userSum = objItem.stream().mapToLong(obj->obj.getValue().getSum()).sum();
                Long actvUserSum = objItem.stream().filter(item1->(item1.getKey().equals("0000"))).
                        mapToLong(obj->obj.getValue().getSum()).sum();

                vo.setEnableUserNum(actvUserSum);
                vo.setUserSumNum(userSum);
                vo.setStopUserNum(userSum-actvUserSum);
                vo.setLoginUserNum(0L);
                vo.setLoginVisit(0L);
                if(!isDiff){
                	LoginUserOrgExportVO lOrgExportVO=diffData.get(key);
                    vo.setLoginUserNum(lOrgExportVO==null?0L:lOrgExportVO.getLoginUserNum());
                    vo.setLoginVisit(lOrgExportVO==null?0L:lOrgExportVO.getLoginVisit());
                }
                recodData.add(vo);
            }
            retData.setRecords(recodData);
        }

        return retData;
    }

    /**
     * 根据用户获取登陆情况
     *
     * @param startDate
     * @param endDate
     * @param kwd
     * @param pageSize
     * @param pageNo
     * @param cid
     * @param siteId
     * @param orgs      @return
     */
//    @Override
//    public Page<LoginUserExportVO> loginLogByAccount(String startDate, String endDate, String kwd,
//                                                     Integer pageSize, Integer pageNo, Long cid,
//                                                     Long siteId, List<Long> orgs,List<Long> siteAdminOrgs) {
//        Page<LoginUserExportVO> retData = new Page<>();
//        // 查询部门列表
//        endDate = endDate+" 23:59:59";
//        if(StringUtils.isNotBlank(kwd)){
//            kwd="%"+kwd+"%";
//        }else {
//            kwd =null;
//        }
//        // 获取用户信息
//        // 开始分页
//        logger.info("分页信息pageSize={},pageNo={}",pageSize,pageNo);
//        if(pageSize != null && pageNo != null){
//            PageHelper.startPage(pageNo,pageSize);
//        }
//        List<LoginUserExportVO> userInfoList = this.baseMapper.accountGroup(kwd,cid,siteId,siteAdminOrgs);
//        if(pageSize != null && pageNo != null){
//
//            retData.setTotal(PageHelper.getTotal());
//            retData.setSize(pageSize);
//            retData.setCurrent(pageNo);
//            PageHelper.remove();
//        }
//        if(!CollectionUtils.isEmpty(userInfoList)){
//            List<LoginUserExportVO> loginInfoList = this.baseMapper.loginLogByAccount
//                    (startDate,endDate,cid,siteId,siteAdminOrgs);
//
//            boolean isDiff = CollectionUtils.isEmpty(loginInfoList);
//            Map<Long,LoginUserExportVO> diffData = null;
//            if(!isDiff){
//                logger.info("************%%%%%%%%%#########******************************根据用户统计出来的登陆信息="+JSON.toJSONString(loginInfoList));
//                diffData = loginInfoList.stream().collect(Collectors.toMap(key->key.getUserId(),val->val));
//            }
//            for(LoginUserExportVO vo : userInfoList){
//                String status = vo.getUserStatus();
//                if(StringUtils.equals(status,"0000")){
//                    vo.setUserStatus("启用");
//                }else {
//                    vo.setUserStatus("停用");
//                }
//                if(!isDiff && diffData.containsKey(vo.getUserId())){
//                    LoginUserExportVO loginInfo = diffData.get(vo.getUserId());
//                    vo.setIsLogin(true);
//                    vo.setLastLoginDate(loginInfo.getLastLoginDate());
//                    vo.setLoginVisit(loginInfo.getLoginVisit());
//                }else{
//                    vo.setIsLogin(false);
//                    vo.setLoginVisit(0L);
//                }
//            }
//            retData.setRecords(userInfoList);
//        }
//        return retData;
//    }
    
    @Override
    public Page<LoginUserExportVO> loginLogByAccount(String startDate, String endDate, String kwd,
                                                     Integer pageSize, Integer pageNo, Long cid,
                                                     Long siteId, List<Long> orgs, List<Long> siteAdminOrgs) {
        Page<LoginUserExportVO> retData = new Page<>();
        // 查询部门列表
        endDate = endDate+" 23:59:59";
        if(StringUtils.isNotBlank(kwd)){
            kwd="%"+kwd+"%";
        }else {
            kwd =null;
        }
        // 获取用户信息
        // 开始分页
        logger.info("分页信息pageSize={},pageNo={}",pageSize,pageNo);
        if(pageSize != null && pageNo != null){
            PageHelper.startPage(pageNo,pageSize);
        }
        List<LoginUserExportVO> list = this.baseMapper.loginLogByAccount(kwd, startDate, endDate, cid, siteId, siteAdminOrgs);
        if(pageSize != null && pageNo != null){

            retData.setTotal(PageHelper.getTotal());
            retData.setSize(pageSize);
            retData.setCurrent(pageNo);
            PageHelper.remove();
        }
        for(LoginUserExportVO user:list) {
            String status = user.getUserStatus();
            if(StringUtils.equals(status,"0000")){
            	user.setUserStatus("启用");
            }else {
            	user.setUserStatus("停用");
            }
        	user.setIsLogin(true);
        	if (user.getLoginVisit()==null) {
        		user.setIsLogin(false);
				user.setLoginVisit(0L);
			}
        }
        retData.setRecords(list);
        return retData;
    }
    
    @Override
    public LoginDataStatisticsVO getLoginCountBySiteId(Long siteId) {
		return this.baseMapper.getLoginCountBySiteId(siteId);
    	
    }

    public static List<String> getStringStream(Integer type, LocalDate startLocalDate, LocalDate endLocalDate) {
        long endNum;
        List<String> retDataKey;
        switch (type){
            case 2:
                endNum =0;
                LocalDate indexStart = null;
                if(! startLocalDate.getDayOfWeek().equals(DayOfWeek.MONDAY)){
                    indexStart = startLocalDate.with(TemporalAdjusters.next(DayOfWeek.MONDAY));
                    endNum++;
                }else{
                    indexStart = startLocalDate;
                }

                //endNum = ChronoUnit.WEEKS.between(indexStart,endLocalDate);
                long diffDay = ChronoUnit.DAYS.between(indexStart,endLocalDate);
                if(diffDay>=7){
                    endNum = endNum+Double.valueOf(Math.ceil(diffDay/7.00)).longValue();
                    if(endLocalDate.getDayOfWeek().equals(DayOfWeek.MONDAY)){
                        endNum++;
                    }
                }else if(diffDay>0){
                    endNum++;
                }else {
                    if(indexStart.equals(endLocalDate)){
                        endNum++;
                    }
                }

                endNum = endNum<=0?1:endNum;
                retDataKey = Stream.iterate(startLocalDate, nextDate->nextDate.with
                        (TemporalAdjusters.next(DayOfWeek.MONDAY))).limit(endNum)
                        .map(item -> item.getYear()+(String.format("%02d",item.get( WeekFields.ISO.weekOfWeekBasedYear()))+SPILT_STR)+
                                item.format(DateTimeFormatter.ofPattern("MM.dd"))+"-"+
                                item.with(TemporalAdjusters.next(DayOfWeek.SUNDAY)).
                                        format(DateTimeFormatter.ofPattern("MM.dd"))).collect(Collectors.toList());
                if(startLocalDate.getDayOfWeek().equals(DayOfWeek.SUNDAY)){
                    String lastVal = retDataKey.get(0);
                    lastVal = lastVal.substring(0,(lastVal.lastIndexOf("-")+1)).concat(startLocalDate.format(DateTimeFormatter.ofPattern("MM.dd")));
                    retDataKey.set(0,lastVal);
                }
                int index = retDataKey.size()-1;
                String lastVal = retDataKey.get(index);
                lastVal = lastVal.substring(0,(lastVal.lastIndexOf("-")+1)).concat(endLocalDate.format(DateTimeFormatter.ofPattern("MM.dd")));
                retDataKey.set(index,lastVal);
                break;
            case 3:
                endNum = Period.between(startLocalDate,endLocalDate).getMonths();
                endNum = endNum<=0?1:endNum+1;
                retDataKey = Stream.iterate(startLocalDate, nextDate->nextDate.plusMonths(1)).limit(endNum)
                        .map(item -> item.format(DateTimeFormatter.ofPattern("yyyyMM"))).collect(Collectors.toList());
                break;
            default:
                endNum = endLocalDate.toEpochDay()-startLocalDate.toEpochDay();
                endNum = endNum<=0?1:endNum+1;
                retDataKey = Stream.iterate(startLocalDate, nextDate->nextDate.plusDays(1)).limit(endNum)
                        .map(item -> item.format(DateTimeFormatter.ofPattern("yyyyMMdd"))).collect(Collectors.toList());
        }
        return retDataKey;
    }
}