package com.yizhi.system.application.task;

import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.context.TaskContext;
import com.yizhi.core.application.file.constant.FileConstant;
import com.yizhi.core.application.file.task.AbstractDefaultTask;
import com.yizhi.core.application.file.util.OssUpload;
import com.yizhi.system.application.domain.LanguageClassify;
import com.yizhi.system.application.mapper.LanguageClassifyMapper;
import com.yizhi.system.application.mapper.LanguageWordMapper;
import com.yizhi.system.application.vo.LanguageJsonVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Component
public class LanguageUpload extends  AbstractDefaultTask<String, Map<String, Object>>{

    private static final Logger logger = LoggerFactory.getLogger(LanguageUpload.class);
    
    @Value("${ACTIVE}")
    public String active;
	
    @Autowired
    private LanguageClassifyMapper languageClassifyMapper;
    
    @Autowired
    private LanguageWordMapper languageWordMapper;
    
	@Override
	protected String execute(Map<String, Object> map) {
		// TODO Auto-generated method stub
		Long classifyId = (Long) map.get("classifyId");
		Integer type = (Integer) map.get("type");
		RequestContext context = ContextHolder.get();
		String terminalType = "";
		switch (type) {
		case 0:
			terminalType = "PC";
			break;
		case 1:
			terminalType = "WECHAT";
			break;
		case 2:
			terminalType = "MANAGE";
			break;

		}
		LanguageClassify classify = languageClassifyMapper.selectById(classifyId);
		/**
		 * 走异步任务
		 */
		Date submitTime = new Date();
		Long taskId = submitTime.getTime();
		String serialNo= "LANGUAGE-UPLOAD"+taskId.toString();
		String taskName = "上传语言"+classify.getName()+"-"+terminalType;
        TaskContext taskContext = new TaskContext(taskId, serialNo, taskName, context.getAccountId(), submitTime, context.getSiteId(), context.getCompanyId());
		working(taskContext);	
		String upLoadUrl=null;
		String requestPath=FileConstant.SAVE_PATH;
		String fileName = new StringBuffer().append("/"+active).append("/"+terminalType).append("/"+classify.getCode()+".json").toString();
		String path = new StringBuffer().append(requestPath).append(fileName).toString();
		FileOutputStream os=null;
		try{
			os= new FileOutputStream(path);
			List<LanguageJsonVO> list = languageWordMapper.getJsonVOs(classifyId, type);
			StringBuffer json = new StringBuffer();
			json.append("{");
			if (CollectionUtils.isNotEmpty(list)) {
				for(LanguageJsonVO vo:list) {
					json.append("\""+vo.getKey()+"\"");
					json.append(":");
					json.append("\""+vo.getValue()+"\"");
					json.append(",");
					json.append("\n");
				}
				json.setCharAt(json.length()-2, '}');
			}else {
				json.append("}");
			}
			os.write(json.toString().getBytes("UTF-8"));
			//阿里云返回url
			upLoadUrl = OssUpload.upload(path, fileName);
			success(taskContext,"成功", upLoadUrl);
			logger.info(classify.getCode()+":上传文件成功，url:"+upLoadUrl);
		} catch(IOException e){
			e.printStackTrace();
			String error = classify.getCode() + ":上传文件不成功，更新语言文件失败" + e.getMessage();
			fail(taskContext, error);
			logger.info(error);
		} finally {
			if (os != null) {
				try {
					os.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return null;
	}

}
