package com.yizhi.system.application.tree;

import com.yizhi.system.application.vo.Tree;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 递归构造树型结构
 *
 * @Author: shengchenglong
 * @Date: 2018/3/22 11:45
 */
public class TreeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TreeBuilder.class);

    /**
     * 获得一个树形结构
     *
     * @param originList
     * @return
     */
    public List<Tree> treeList(List<Tree> originList) {
        List<Tree> list = new ArrayList<Tree>();
        if (CollectionUtils.isNotEmpty(originList)) {
            for (Tree x : originList) {
                if (null != x) {
                    if (x.getParentId() == 0) {
                        x.setChildren(treeChild(originList, x.getKey()));
                        list.add(x);
                    }
                }
            }
        }
        return list;
    }

    /**
     * 获得子节点
     *
     * @param id
     * @return
     */
    public List<Tree> treeChild(List<Tree> treeList, Long id) {
        List<Tree> tempList = new ArrayList<Tree>();
        if (CollectionUtils.isNotEmpty(treeList)) {
            for (Tree a : treeList) {
                if (null != a) {
                    if (a.getParentId().longValue() == id.longValue()) {
                        a.setChildren(treeChild(treeList, a.getKey()));
                        tempList.add(a);
                    }
                }
            }
        }
        return tempList;
    }

    /**
     * 获取某一tree以及下面的所有子节点
     *
     * @param all 整个树形结构
     * @param id  需要拿取的tree
     * @return
     */
    public Tree getChildList(List<Tree> all, Long id) {
        Tree temp = null;
        if (CollectionUtils.isNotEmpty(all)) {
            for (Tree tree : all) {
                if (null != tree) {
//            		logger.info("tree==",JSON.toJSONString(tree));
                    if (tree.getKey().longValue() == id.longValue()) {
                        temp = tree;
                        break;
                    } else {
                        List<Tree> childs = tree.getChildren();
                        if (CollectionUtils.isNotEmpty(childs)) {
                            temp = getChildList(childs, id);
                        }
                    }
                }
                if (temp != null) {
                    break;
                }
            }
        }
        return temp;
    }


    public List<Long> getChildIds(List<Long> ids, Tree tree) {
        if (null == ids) {
            ids = new ArrayList<Long>();
        }
        if (null != tree) {
            ids.add(tree.getKey());
            List<Tree> childs = tree.getChildren();
            if (CollectionUtils.isNotEmpty(childs)) {
                for (Tree tree1 : childs) {
                    if (null != tree1) {
                        getChildIds(ids, tree1);
                    }
                }
            }
        }
        return ids;
    }

    public List<Long> getChiefIds(List<Tree> all, Long id, List<Long> ids) {
        if (null == ids) {
            ids = new ArrayList<Long>();
        }
        ids.add(id);
        Tree tree = getChildList(all, id);
        if (null != tree && tree.getParentId() != 0L) {
            getChiefIds(all, tree.getParentId(), ids);
        }
        return ids;
    }

    public List<Tree> treeList(List<Tree> originList, Boolean noKey) {
        Set<Long> topKeys = findTopKey(originList);
        List<Tree> list = new ArrayList<Tree>();
        if (CollectionUtils.isNotEmpty(originList)) {
            for (Tree x : originList) {
                if (null != x) {
                    if (topKeys.contains(x.getParentId())) {
                        x.setChildren(treeChild(originList, x.getKey()));
                        list.add(x);
                    }
                }
            }
        }
        return list;
    }

    private HashSet findTopKey(List<Tree> originList) {
        if (!CollectionUtils.isEmpty(originList)) {
            Set<Long> ids = new HashSet();
            Set<Long> pIds = new HashSet();

            for (Tree tree : originList) {
                ids.add(tree.getKey());
                pIds.add(tree.getParentId());
            }

            HashSet<Long> topKeys = new HashSet();
            for (Long o : pIds) {
                if (!ids.contains(o)) {
                    topKeys.add(o);
                }
            }
            return topKeys;
        }
        return null;
    }

}
