package com.yizhi.system.application.util;

import java.security.SecureRandom;
import java.util.Random;

public class SaltUtil {
	
	static int length = 16;
	
    /**
     * 获取随机的盐
     * @return 盐 
     */
	public static String getSalt(){
		char[] chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
		char[] saltchars = new char[length];
		Random RANDOM = new SecureRandom();
		for(int i=0;i<length;i++)
		{
		int n = RANDOM.nextInt(62);
		saltchars[i] = chars[n];
		}
		String salt = new String(saltchars);
		return salt;
	}
	
    /**
     * 带盐加密
     *
     * @param str  字符串
     * @param salt 盐
     * @param publicKey 公钥
     * @return 密文
     * @throws Exception 加密过程中的异常信息
     */
	public static String encrypt(String str, String salt, String publicKey) throws Exception {
			String encrypt = RSAUtil.encrypt(str+salt, publicKey);
			return encrypt;
	}

	public static String encryptNosalt(String str, String publicKey) throws Exception {
		String encrypt = RSAUtil.encrypt(str, publicKey);
		return encrypt;
	}
	
    /**
     * 带盐解密
     *
     * @param str  加密字符串
     * @param salt 盐
     * @param privateKey 私钥
     * @return 铭文
     * @throws Exception 解密过程中的异常信息
     */
	public static String decrypt(String str, String salt, String privateKey) throws Exception {
			String decrypt = RSAUtil.decrypt(str, privateKey);
		System.out.println(decrypt);
			if (!salt.equals(decrypt.substring(decrypt.length()-length))) {
				return null;
			}
			return decrypt.substring(0, decrypt.length()-length);
	}

	
	/**
	 * 解密
	 * @param str 加密字符串
	 * @param privateKey 私钥
	 * @return 铭文
	 * @throws Exception
	 */
	public static String decryptNosalt(String str, String privateKey) throws Exception {
		String decrypt = RSAUtil.decrypt(str, privateKey);
		return decrypt;
	}
	
	public static void main(String[] args) throws Exception {

		String salt1 = "TyGglO70z7GbJpE+";
		String rsaName = "Xuy5UMKNf6LfHnJxHjUHIuSRAUL1mZf3UE1HNU9lpdWKQD2Qfy3mNiYqjSwYKYfa5dxpTU+GZ7FvKlbnt+r5PUqaMuzNy/JJtHDGDKbf27K/oN1/TATpdFf4Rk8e8pW+Zp13Lwm4MDoijPmOU4nLdXwoLk22CB7vPyzI95emnaA=";
		String rsaPrivete = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAI8iMLn1dbm207YqA4nBdTBUoN6iul/bAA2dauThC88pbu/kvLv42WKd2xGC7Sz6AIxvvi4tbYJ6yEvW3qJY+vj5ua/2qh1XPdH4AGi4nfefJo1zcWTdgUCeFU4zBKkp0kEvCXhLo6MypHT8Zt5eIf/6ZR2X9sXkcOui11RFFcvTAgMBAAECgYBrjuXO2AV/aUPuv+OowRevGelJZD9piMihconBNNwK8LfMzbaGCppQ4Q6eOiTAh52h6tafHMQOKPYbB3yFwxfUn/5+RhhsDU0dc4FWIKyMrQQwJZTerVWVrcmCLGqVRHEPNUkdfZ8s4tF/9ZBriFx+bRrjoc7+OW1oqgCX9ktKAQJBANFBOlSmrUDgBBfEuP8DKz00U2NCK4JBDJhwEbveux1G4LWelc/yvbcdsruyx3IakNN8yxsJt0V1lIeANgGaTAsCQQCvG6ZY3xS8aTnUGLRfRGXIfc1kKTau+1Jx8Cxh9NmtXTKygz1FUIenyB3ezzKSftUR0R0cBK1vA9AU+KA5UZRZAkEAoiV4LKYnNFEh+sT+UOTEuZ11TEG28yyytOCKbViPB4WnlDR5g/Rl26IQoG9NKva46JgXzjC+Kf2NhV3s+1rztwJBAIvL1j0DNAnLNCi45F9eOqgajzwUjxyZdlOSO8ykbpgyXIQZtHO++94eLIKyBhzgdvh3avbwYQnNEHV9nGTGVVkCQEtUSX4+o++Zw7eVVnlFOvrSrM09uFqD5gBqhaMxzxMqHggSidlXigAQCz+2Dzsn/sy3GpySWYi7Iv2ysDYtMSw=";
		String nameTmp = decrypt(rsaName, salt1, rsaPrivete);
		System.out.println(nameTmp);
		/*String salt = getSalt();
		String nameString = "admin";
		String eName = encrypt(nameString, salt, RSAUtil.PUBLIC_KEY);
		String dName = decrypt(eName, salt, RSAUtil.PRIVATE_KEY);
		System.out.println(salt);
		System.out.println("----------------");
		System.out.println("明文加盐加密前：" + nameString + " 明文加盐加密后：" + eName + " 明文加盐解密后：" + dName);
		System.out.println("----------------");
		String rsaEname = RSAUtil.encrypt(dName, RSAUtil.PUBLIC_KEY);
		String rsaDname = RSAUtil.decrypt(rsaEname, RSAUtil.PRIVATE_KEY);
		System.out.println("返回结果公钥加密后：" + rsaEname + "返回结果私钥解密后：" + rsaDname);
		String privateKey = "MIICdwIBADANBgkqhkiG9w0BAQEFAASCAmEwggJdAgEAAoGBAI8iMLn1dbm207YqA4nBdTBUoN6iul/bAA2dauThC88pbu/kvLv42WKd2xGC7Sz6AIxvvi4tbYJ6yEvW3qJY+vj5ua/2qh1XPdH4AGi4nfefJo1zcWTdgUCeFU4zBKkp0kEvCXhLo6MypHT8Zt5eIf/6ZR2X9sXkcOui11RFFcvTAgMBAAECgYBrjuXO2AV/aUPuv+OowRevGelJZD9piMihconBNNwK8LfMzbaGCppQ4Q6eOiTAh52h6tafHMQOKPYbB3yFwxfUn/5+RhhsDU0dc4FWIKyMrQQwJZTerVWVrcmCLGqVRHEPNUkdfZ8s4tF/9ZBriFx+bRrjoc7+OW1oqgCX9ktKAQJBANFBOlSmrUDgBBfEuP8DKz00U2NCK4JBDJhwEbveux1G4LWelc/yvbcdsruyx3IakNN8yxsJt0V1lIeANgGaTAsCQQCvG6ZY3xS8aTnUGLRfRGXIfc1kKTau+1Jx8Cxh9NmtXTKygz1FUIenyB3ezzKSftUR0R0cBK1vA9AU+KA5UZRZAkEAoiV4LKYnNFEh+sT+UOTEuZ11TEG28yyytOCKbViPB4WnlDR5g/Rl26IQoG9NKva46JgXzjC+Kf2NhV3s+1rztwJBAIvL1j0DNAnLNCi45F9eOqgajzwUjxyZdlOSO8ykbpgyXIQZtHO++94eLIKyBhzgdvh3avbwYQnNEHV9nGTGVVkCQEtUSX4+o++Zw7eVVnlFOvrSrM09uFqD5gBqhaMxzxMqHggSidlXigAQCz+2Dzsn/sy3GpySWYi7Iv2ysDYtMSw=";
		try {
			String name = decrypt("YTfM5PsQY+KOA0zg95Ch+VUWZ1H5GEwWgocRpqzEqDuAkDYr5Xrcmep8dOrvGuLlx5mLS/bvRXpU69BXtfcnVhRpqbrsZKwsf5Jv+7ncIlhhrfydzI/CvZvb4jff5+dQnZ/Ftqt3lswQk3EftogWDIqsWhJeaW8VXhIDmJEhlp4","94508284bfd65018", privateKey);
			System.out.println("解密的用户名"+name);
		}catch (Exception e){
			System.out.println(e);
		}*/
	}
}
