package com.yizhi.util.application.domain;

import com.yizhi.util.application.constant.ReturnCode;
import com.yizhi.util.application.enums.i18n.Constants;
import com.yizhi.util.application.page.PageInfo;
import com.yizhi.util.application.page.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.tuple.Pair;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 响应数据封装类
 * subCode和subMsg应该在各微服务里如ReturnCode定义具体业务错误枚举信息
 * @author scotthu
 *
 * @param <T>
 */
@ApiModel(value = "BizResponse", description = "响应信息封装")
public class BizResponse<T> implements Serializable {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(notes = "响应代码")
	private String code = Constants.MSG_SUCCESS.getCode().toString(); //响应码
	@ApiModelProperty(notes = "响应信息")
	private String msg  = Constants.MSG_SUCCESS.getName();  //响应说明

	@ApiModelProperty(notes = "业务错误码")
	private String subCode; //业务响应码
	@ApiModelProperty(notes = "业务错误说明")
	private String subMsg;  //业务错误说明

	@ApiModelProperty(notes = "响应数据")
	protected transient T data; //响应数据


	private BizResponse() {

	}
	
	/**
	 * 返回成功响应
	 */
	public static <T> BizResponse<T> ok() {
		BizResponse<T> response = new BizResponse<T>();
		response.code = Constants.MSG_SUCCESS.getCode().toString();
		response.msg = Constants.MSG_SUCCESS.getName();
		return response;
	}
	
	/**
	 * 返回成功响应,携带数据
	 */
	public static <T> BizResponse<T> ok(T data) {
		BizResponse<T> response = ok();
		response.data = data;
		return response;
	}


    public static <T> BizResponse<T> ok(String subCode, String subMsg) {
        BizResponse<T> response = ok();
        response.subCode = subCode;
        response.subMsg = subMsg;
        return response;
    }

    /**
	 * 返回成功响应
	 */
	public static <T> BizResponse<T> ok(String code, String msg, T data) {
		BizResponse<T> response = new BizResponse<T>();
		response.code = code;
		response.msg = msg;
		response.data = data;
		
		return response;
	}
	
    @Deprecated
	/**
	 * 以后弃用，必须返回自己业务的subCode和subMsg
	 */
	public static <T> BizResponse<T> fail() {
		BizResponse<T> response = new BizResponse<T>();
		response.code = Constants.MSG_BIZ_FAIL.getCode().toString();
		response.msg = Constants.MSG_BIZ_FAIL.getName();
		return response;
	}

	@Deprecated
	/**
	 * 新的消息返回必须Constants枚举类定义
	 */
	public static <T> BizResponse<T> fail(ReturnCode returnCode) {
		BizResponse<T> response = fail();
		response.code = returnCode.getCode();
		response.msg = returnCode.getMsg();
		return response;
	}

	public static <T> BizResponse<T> fail(Constants returnCode) {
		BizResponse<T> response = fail();
		response.subCode = returnCode.getCode().toString();
		response.subMsg = returnCode.getName();
		return response;
	}

	public static <T> BizResponse<T> fail(String subCode, String subMsg) {
		BizResponse<T> response = fail();
		response.subCode = subCode;
		response.subMsg = subMsg;
		return response;
	}
	
	public static <T> BizResponse<T> fail(String subMsg) {
		BizResponse<T> response = fail();
		response.subMsg = subMsg;
		return response;
	}

	public static <T> BizResponse<T> fail(String code, String msg, T data) {
		BizResponse<T> response = new BizResponse<T>();
		response.code = code;
		response.msg = msg;
		response.data = data;
		return response;
	}


	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public String getSubCode() {
		return subCode;
	}

	public void setSubCode(String subCode) {
		this.subCode = subCode;
	}

	public String getSubMsg() {
		return subMsg;
	}

	public void setSubMsg(String subMsg) {
		this.subMsg = subMsg;
	}

	public T getData() {
		return data;
	}

	public void setData(T data) {
		this.data = data;
	}
}
