package com.yizhi.util.application.enums.i18n;

/**
 * @Author: XieHaijun
 * @Description: 国际化常量表（  常量命名以【项目名_业务相关...】，全大写；） 每个定义后加注解，简单说明含义
 *                             code 命名【六位数，每个系统第一个数区分，新的系统在该数字上递增，如果到10就变成7位；
 *                             name 命名【使用英文单词描述，多个单次之间用.点号隔开，全小写】（添加之前全局搜索下，是否定义过）
 * @Date: Created in 11:35 2018/12/10
 * @Modified By
 */
public enum Constants {

	ALBUM_HAS_OFFLINE(1400001,"album.has.offline"),//专辑未上架,不能查看
    ALBUM_MSG_BIZ_ERROR(1400000,"album.biz.error"),
    LECTURER_MSG_BIZ_ERROR(1300000,"lecturer.biz.error"),
    LECTURER_CLASSIFICATION_UP_ERROR(1310000,"Please up the parent classification!"),

    CASELIBRARY_HAS_OFFLINE(1200000,"caselibrary.has.offline"),//案例活动已经下架,不能参加
    CASELIBRARY_SELECT_NULL(1200001,"Please select at least one item"),//至少选择一条记录
    STUDENTCASE_HAS_OFFLINE(1200002,"studentCase.has.offline"),//学员案例已经被删除,或者不存在
    CASELIBRARY_MSG_BIZ_ERROR(1200003,"caselibray.biz.error"),
    //资料库服务
    DOCUMENT_PARAMS_ERR(1100000,"params.err"),//参数缺少
    DOCUMENT_NO_DOWNLOAD_AUTH(1100001,"no.download.auth"),//没有下载权限
    DOCUMENT_TERMINAL_TYPE_ERR(1100002,"terminal.type.err"),//终端类型错误
    DOCUMENT_NO_ENROLL(1100003,"doc.no.enroll"),//你尚未报名，报名成功后方可查看项目资料。
    DOCUMENT_NOT_START_ENROLL(1100004,"doc.not.start.enroll"),//报名尚未开始，暂时无法查看项目资料。
    DOCUMENT_ENROLL_END(1100005,"doc.enroll.end"),//报名已结束，无法查看项目资料。
    DOCUMENT_ADUIT_ING(1100006,"doc.auditing"),//报名审核中，暂无法查看项目资料。
    DOCUMENT_AUDIT_FAiL(1100007,"doc.auditing.fail"),//报名未通过，无法查看项目资料。
    DOCUMENT_MEMBER_FULL(1100008,"doc.full"),//名额已满，无法查看项目资料。
    DOCUMENT_PROJECT_NOT_START(1100008,"doc.not.start"),//项目未开始，暂无法查看项目资料。

    // 积分服务（training）,code:5XXXXX
    // 消息类型(MSG开头)
    // 积分服务异常
    POINT_MSG_BIZ_ERROR(1010000,"biz.error"),

    // 证书服务（training）,code:5XXXXX
    // 消息类型(MSG开头)
    // 证书服务异常
    CERTIFICATE_MSG_BIZ_ERROR(910000,"biz.error"),


    // 调研服务（training）,code:5XXXXX
    // 消息类型(MSG开头)
    //调研服务异常
    RESEARCH_MSG_BIZ_ERROR(810000,"biz.error"),
    RESEARCH_MSG_QUESTION_NOT_ANSWER(810001,"msg.question.not.amswer"),//必答题没有回答
    RESEARCH_MSG_SUBMIT_REPEATITION(810002,"msg.repeat.submit"),//重复提交
     RESEARCH_MSG_ANSWER_TOO_SHORT(810003,"msg.answer.short"),//答案未超过5个字


    // 考试服务（training）,code:5XXXXX
    // 消息类型(MSG开头)
    //考试服务异常
    EXAM_MSG_BIZ_ERROR(710000,"biz.error"),
    EXAM_MSG_NO_EXAM_TIMES(710001,"msg.has.no.exam.times"),//该考试没有考试次数了
    EXAM_MSG_SUBMIT_REPEATITION(710002,"msg.exam.repeat.submit"),//该考试已经提交过了，不能重复提交
    EXAM_MSG_SUBMITED(710003,"msg.submited"),//該場考試已經提交,不能繼續考試
    EXAM_MSG_EXAM_NOT_BEGIN(710003,"msg.exam.not.begin"),
    EXAM_MSG_EXAM_HAS_END(710003,"msg.exam.end"),

    // 作业服务（training）,code:5XXXXX
    // 消息类型(MSG开头)
    // 作业服务异常
    ASSIGNMENT_MSG_BIZ_ERROR(610000,"biz.error"),
    ASSIGNMENT_MSG_RESOURSE_NOT_EXIST(610001,"msg.resourse.not.exist"),//作业资源不存在
    ASSIGNMENT_MSG_SUBMIT_NULL(610002,"msg.submit.null"),//提交作业内容为空
    ASSIGNMENT_MSG_WRONG_SUBMIT(61003,"WrongSubmit"),//答案不符合提交要求
    ASSIGNMENT_MSG_END(61004,"AssignmentEnded"),//该作业已逾期
    ASSIGNMENT_MSG_EXCEEDING_NUMBER_SUBMIT(61004,"msg.assignment.exceeding.number"),//提交次数达到上限



    // 培训服务（training）,code:5XXXXX
        // 消息类型(MSG开头)
    // 培训服务异常
    TRAINING_MSG_BIZ_ERROR(510000,"biz.error"),
    TRAINING_MSG_ENROLL_NO_START(510050,"ApplyNotStarted"),//报名未开始
    TRAINING_MSG_ENROLL_END(510051,"ApplyExpired"),//报名已结束
    TRAINING_MSG_QUOTA_FULL(510060,"msg.quota.full"),//名额已满
    TRAINING_MSG_IMMEDIATELY_ENROLL(510061,"msg.immediately.enroll"),//立即报名
    TRAINING_MSG_START_LEARNING(510062,"msg.start.learning"),//开始学习
    TRAINING_MSG_AUDIT_ING(510063,"msg.audit.ing"),//审核中
    TRAINING_MSG_AUDIT_FAIL(510064,"msg.audit.fail"),//审核不通过
    TRAINING_MSG_AUDIT_SUCCESS(510065,"msg.audit.success"),//审核通过
    TRAINING_MSG_NOT_NEED_AUDIT(510066,"msg.not.need.audit"),//不需要审核
    TRAINING_MSG_PROJECT_NOT_EXiST(510067,"msg.project.not.exist"),//项目不存在
    TRAINING_MSG_ONLY_AUDIT_SUCCESS_TO_SEE_ACTIVITY(510068,"msg.only.audit.success.to.see.activity"),//您尚未报名，报名成功后可进行学习。
    TRAINING_MSG_HASENROLLED(510069,"msg.has.enrolled"),//已经报名
    TRAINING_MSG_NOT_NEED_ENROLL(510070,"msg.not.need.enroll"),//无需报名
    TRAINING_MSG_ENROLL_FAIL(510071,"msg.enroll.fail"),//报名失败
    TRAINING_MSG_PLAN_NOT_DELETE(510072,"msg.plan.not.delete"),//该计划已被其他计划作为前置计划所依赖，不能删除！
    TRAINING_MSG_ENROLL_NOT_START(510073,"msg.enroll.not.start"),//报名尚未开始，无法进行项目学习！
    TRAINING_MSG_ENROLL_IS_END(510074,"msg.enroll.is.end"),//报名已结束，无法进行项目学习！
    TRAINING_MSG_QUOTA_FULL_NOT_STUDY(510075,"msg.quota.full.not.study"),//名额已满,无法进行项目学习！
    TRAINING_MSG_AUDIT_ING_NOT_STUDY(510076,"msg.audit.ing.not.study"),//报名审核中,无法进行项目学习！
    TRAINING_MSG_AUDIT_FAIL_NOT_STUDY(510077,"msg.audit.fail.not.study"),//报名审核未通过,无法进行项目学习！
    TRAINING_MSG_PROJECT_IS_END(510088,"msg.project.is.end"),//项目已结束,无法进行项目学习！




    // 培训服务（training）,code:52XXXX
        // 消息类型(MSG开头)
    TRAINING_MSG_TIME_NOT_STARTED(520001,"msg.time.not.started"),//培训时间未开始,请等待！
    TRAINING_MSG_STUDY_PLAN_NOT_FINISHED(520002,"msg.study.plan.not.finished.not.start.new.plan"),//前置计划未完成
    TRAINING_MSG_CURRENT_STUDY_PLAN_NOT_AVAILABLE(520003,"msg.current.study.plan.not.start"),//当前学习计划时间未到,无法开始学习
    TRAINING_MSG_CURRENT_PLAN_EXPIRED_NOT_LEARNED(520004,"msg.current.plan.expired.not.learned"),//当前计划已过期,无法进行学习

    //培训服务(调研)
    TRAINING_MSG_THE_RESEARCH_COMPLETED(520005,"the.research.completed"),//当前调研已完成,谢谢您的参与

    // 证书消息类型code:53XXXX
    TRAINING_MSG_CERTIFICATE_UNABLE_OBTAIN(530001,"msg.unable.obtain.certificate"),//当前计划尚未完成,无法获得证书
    TRAINING_MSG_CERTIFICATE_HAS_OBTAINED(530002,"certificate.has.obtained"),//已经获取过该证书
    TRAINING_MSG_CERTIFICATE_SUCCESS_GET(530003,"certificate.success.get"),//证书获取成功,请到"我的学习-我的证书"进行查看和下载
    // 证书获取状态
    TRAINING_MSG_TO_GET_THE_CERTIFICATE(530010,"get.the.certificate"),//获取证书(状态)
    TRAINING_MSG_CERTIFICATE_OBTAINED(530011,"certificate.obtained"),//已获取证书(状态)

    // 培训服务( 线下课程 获取状态)
    TRAINING_MSG_DATA_NOT_IMPORTED(530021,"data.not.imported"),//数据未导入(状态)
    TRAINING_MSG_UNFINISHED(530022,"unfinished"),//未完成(状态)
    TRAINING_MSG_FINISHED(530023,"finished"),//已完成(状态)

    // 培训服务中的活动状态
    TRAINING_MSG_ACTIVITY_STATUS_NOT_COMPLETED(530030,"activity.status.not.completed"),//活动状态未完成  (未完成)
    TRAINING_MSG_THE_ACTIVE_STATE_COMPLETE(530031,"the.active.state.complete"),//活动状态已完成  (已完成)
    TRAINING_MSG_ACTIVE_STATUS_IN_PROGRESS(530032,"active.status.in.progress"),//活动状态进行中  (进行中)



    // 课程服务（course）,code:4XXXXX
    // 消息类型(MSG开头)
    // 课程服务异常
    COURSE_MSG_BIZ_ERROR(410001,"biz.error"),
    COURSE_MSG_COURSE_DETAIL_QUERY_FAIL(410002,"msg.course.detail.query.fail"),//课程详情获取失败
    COURSE_MSG_COURSE_DETAIL_NON_EXISTENT(410003, "msg.course.detail.non.existent"),//课程详情不存在
    COURSE_MSG_COURSE_ACCESS_SITE_DIFFERENT(410004, "msg.course.access.site.different"),//课程站点和访问站点不一致
    COURSE_MSG_COURSE_NOT_WECHAT_CERTIFICATION(410005,"msg.course.not.wechat.certification"),//未微信认证
    COURSE_MSG_COURSE_TEL_USED(410006,"msg.course.tel.used"),//该手机号已经被使用
    COURSE_MSG_COURSE_SMS_FREQUENTLY_SEND(410007,"msg.course.sms.frequently.send"),//短信频繁发送
    COURSE_MSG_COURSE_TEL_SMS_MULTIPLE_SEND(410008,"msg.course.tel.sms.multiple.send"),//该手机号存在验证码多次发送
    COURSE_MSG_COURSE_CAPTCHA_NON_EXISTENT(410009,"msg.course.captcha.non.existent"),//验证码不存在
    COURSE_MSG_COURSE_CAPTCHA_EXPIRED(410010,"msg.course.captcha.expired"),//验证码已经过期

    //直播服务(live),code:1110000
    // 消息类型(MSG开头)
    // 直播服务异常
    LIVE_MSG_CHANNEL_NOT_EXIST_OR_CLOSED(1110001,"msg.channel.not.exist.or.closed"),//直播频道不存在或已关闭
    LIVE_MSG_CHANNEL_RESPONSE_EXCEPTION(1110002,"msg.channel.response.exception"),//直播频道响应异常

    // 网关（gateWay）,code:3XXXXX
    // 消息类型(MSG开头)
    GATEWAY_MSG_PWD_ERROR(310000,"pwd.error"),// 密码错误
    // 常量值类型（VAL开头）
    GATEWAY_VAL_SMS_TYPE(320000,"simple.sms.type"),// 单次短信发送

    // 系统关联（SYSTEM）,code:2XXXXX
    // 消息类型(MSG开头)
    SYSTEM_MSG_MOBILE_NUMBER_EMPTY(210000,"mobile.number.empty"),// 手机号码为空
    SYSTEM_MSG_MOBILE_NUMBER_UNBOUND(210001,"mobile.number.unbound"),// 手机号码未绑定
    SYSTEM_MSG_MOBILE_MULTIPLE_ACCOUNTS_BOUND(210002,"mobile.multiple.accounts.bound"),// 手机号被多个账号绑定
    SYSTEM_MSG_MOBILE_NUMBER_NOT_REGISTERED(210003,"mobile.number.not.registered"),// 手机号未注册
    SYSTEM_MSG_MOBILE_NUMBER_ILLEGAL(210004,"mobile.number.illegal"),// 手机号不正确
    SYSTEM_MSG_ACCOUNT_DISABLE_OR_LOCKD(210010,"account.disable.or.lockd"),// 账号未启用或者锁定
    SYSTEM_MSG_ACCOUNT_EXPIRED(210011,"account.expired"),// 账号已过期
    SYSTEM_MSG_ACCOUNT_NOT_EXIST(210012,"account.not.exist"),// 账号不存在
    SYSTEM_MSG_ACCOUNT_EXIST(210013,"account.exsit"),//账号已存在
    SYSTEM_MSG_SMS_VERIFY_CODE_EXPIRED(210020,"sms.verify.code.expired"),// 短信验证码已过期
    SYSTEM_MSG_SMS_VERIFY_CODE_ERROR(210021,"sms.verify.code.error"),// 短信验证码错误
    SYSTEM_MSG_SMS_SEND_MAX_LIMIT(210022,"sms.send.max.limit"),// 短信发送太频繁
    SYSTEM_MSG_SMS_SEND_ERROR(210023,"sms.send.error"),// 短信发送错误
    SYSTEM_MSG_PWD_EMPTY(210030,"pwd.empty"),// 密码为空
    SYSTEM_MSG_CODE_EMPTY(210031,"code.empty"),//验证码为空
    SYSTEM_MSG_EXTENT_EMPTY(210037,"sms.sno.empty"),//短信验证码发送成功后返回的业务号传参为空
    SYSTEM_MSG_CONFIRM_PWD_NOT_CORRECT(210034,"confirm.pwd.not.correct"),// 确认密码不正确
    SYSTEM_MSG_PWD_NOT_CORRECT(210032,"pwd.not.correct"),// 密码不正确
    SYSTEM_MSG_PWD_EXITS(210038,"pwd.exits"),// 密码已存在
    SYSTEM_MSG_IMG_VERIFY_CODE_EXPIRED(210040,"img.verify.code.expired"),// 图形验证码已过期
    SYSTEM_MSG_IMG_VERIFY_CODE_NOT_CORRECT(210041,"img.verify.code.not.correct"),// 图形验证码不正确
    SYSTEM_MSG_WECHAT_BIND_ERROR(210050,"wechat.bind.error"),// 微信绑定异常
    SYSTEM_MSG_COMPANY_NOT_EXIST(210090,"company.not.exist"),// 公司不存在
    SYSTEM_MSG_PWD_CHANGE_SUCCESS(210054,"PwdchangeSuccess"),// 密码修改成功
    SYSTEM_MSG_OLD_PWD_ERROR(210093,"oldPasswordError"),// 旧密码输入不正确
    // 常量值类型（VAL开头）
    SYSTEM_VAL_SMS_TYPE(220000,"simple.sms.type"),// 单次短信发送

    PORT_MSG_TERMINAL_NAME_ERROR(410000,"terminal.name.error"),//终端名称错误

    // 共通常量（不要前置项目名）
    // 消息类型(MSG开头)
    MSG_SUCCESS(1000,"success"),// 接口调用成功
    MSG_REQUEST_ERROR(10001,"request.error"),// 请求参数错误
    MSG_NOT_SITE_ACCESS_AUTH(10002,"not.site.access.auth"),//没有站访问权限
    MSG_NOT_MANAGE_AUTH(10003,"not.manage.auth"),//没有管理权限
    MSG_BIZ_FAIL(4000,"biz.fail"),// 业务处理失败

    MSG_COMMENT_FAIL(210080,"msg.comment.fail"),//评论失败
    MSG_REPLY_COMMENT_FAIL(210081,"msg.reply.comment.fail"),//回复评论失败
    MSG_COMMENT_THUMBSUP_FAIL(210082,"msg.comment.thumbsup.fail"),//评论点赞失败
    MSG_CANCEL_THUMBSUP_FAIL(210083,"msg.cancel.thumbsup.fail"),//取消点赞失败、
    MSG_COMMENT_IS_NOT_NULL(210084,"msg.comment.not.null"),//评论不能为空
    MSG_REPLY_IS_NOT_NULL(210085,"msg.reply.not.null"),//回复不能为空
    MSG_COMMENT_SUCCESS(210086,"CommentSuccess"),//评论成功
    MSG_REPLY_SUCCESS(210087,"ReplySuccess"),//回复成功
    NON_COMPLIANT_PASSWORD(210088,"Non-compliant.password"),//密码不符合规范
    APP_ID_FAIL(-1000,"appId不正确"),
    ACCESS_TOKEN_NO_EXIST(-1010,"access_token接口调用凭证已超时"),
    AUTH_CORPID_FAIL(-1001, "authCorpId不正确，请先联系轻学堂配置"),
    SIGN_FAIL(-1002,"sign不正确"),
    SYSTEM_MSG_ACCOUNT_PWD_ERROR(210089,"account.pwd.error"),// 用户名或密码错误
    SYSTEM_MSG_PWD_ERROR1(210081,"pwd.error.times1"),//密码错误！您还有4次机会
    SYSTEM_MSG_PWD_ERROR2(210082,"pwd.error.times2"),// 密码错误！您还有3次机会
    SYSTEM_MSG_PWD_ERROR3(210083,"pwd.error.times3"),// 密码错误！您还有2次机会
    SYSTEM_MSG_PWD_ERROR4(210084,"pwd.error.times4"),// 密码错误！您还有1次机会
    SYSTEM_MSG_PWD_ERROR5(210085,"pwd.error.times5"),// 密码错误！您还有0次机会
    SYSTEM_MSG_PWD_ERROR(210080,"pwd.error.times");// 很抱歉，您已累计5次输错密码了，账号已被锁定，请15分钟后重试
    // 常量值类型（VAL开头）
    //VAL_SMS_TYPE(120000,"simple.sms.type");// 单次短信发送

    private Integer code;
    private String name;
    Constants(Integer code, String name) {
        this.code = code;
        this.name = name;
    }
    public Integer getCode() {
        return code;
    }
    public String getName() {
        return name;
    }
}
