package com.yizhi.util.application.num;

import java.math.BigDecimal;

/**
 * @ClassName NumUtil
 * @Description TODO
 * @Author shengchenglong
 * @DATE 2019-10-10 11:25
 * @Version 1.0
 */
public class NumUtil {

    public static final String PERCENTAGE_SYMBOL = "%";

    public static final BigDecimal HUNDRED_PERCENTAGE = new BigDecimal(100);

    public static final BigDecimal ONE = new BigDecimal(1);

    /**
     * 求当前于上一期的环比
     * @param current   当前数据    数字
     * @param prefix    上一期数据  数字
     * @param scale     保留几位小数
     * @return
     */
    public static String getChainPercentage(Object current, Object prefix, int scale) {
        BigDecimal currentN = new BigDecimal(current.toString());
        BigDecimal prefixN = new BigDecimal(prefix.toString());

        BigDecimal res = currentN.subtract(prefixN)
                .divide(prefixN, scale + 2, BigDecimal.ROUND_HALF_UP)
                .multiply(HUNDRED_PERCENTAGE)
                .divide(ONE, scale, BigDecimal.ROUND_HALF_UP);
        return res.toString().concat(PERCENTAGE_SYMBOL);
    }

    /**
     * 求百分比
     * @param dividend
     * @param divisor
     * @param scale
     * @return
     */
    public static String getPercentage(Object dividend, Object divisor, int scale) {
        BigDecimal dividendN = new BigDecimal(dividend.toString());
        BigDecimal divisorN = new BigDecimal(divisor.toString());
        BigDecimal a = dividendN.multiply(new BigDecimal("100"));
        BigDecimal res = a.divide(divisorN, scale, BigDecimal.ROUND_HALF_UP);

        return res.toString().concat(PERCENTAGE_SYMBOL);
    }

}
