package com.yizhi.util.application.sensitive;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * @Description: 敏感词过滤
 * @Author : xiehaijun
 * @Date ： 2018年5月8日 下午2:27:06
 */
public class SensitivewordFilter {

    //最小匹配规则
    public static int minMatchTYpe = 1;
    //最大匹配规则
    public static int maxMatchType = 2;

    public static final String DEFAULT_REPLACE_CHAR = "*";

    /**
     * 铭感词过滤(默认以*号替换敏感词)
     *
     * @param text          待过滤的文本信息
     * @param sensitiveWord 关键字列表
     * @return
     */
    public static String sensitiveFilter(String text, Set<String> sensitiveWord) {
        int matchType = 1;
        return sensitiveFilter(text, sensitiveWord, matchType, DEFAULT_REPLACE_CHAR);
    }

    /**
     * 铭感词过滤(默认以*号替换敏感词)
     *
     * @param text          待过滤的文本信息
     * @param sensitiveWord 关键字列表
     * @param replaceChar   替换的字符
     * @return
     */
    public static String sensitiveFilter(String text, Set<String> sensitiveWord, String replaceChar) {
        int matchType = 1;
        return sensitiveFilter(text, sensitiveWord, matchType, replaceChar);
    }

    /**
     * 铭感词过滤
     *
     * @param text          待过滤的文本信息
     * @param sensitiveWord 关键字列表
     * @param matchType     匹配规则；1：最小匹配规则；2：最大匹配规则
     * @param replaceChar
     * @return
     */
    public static String sensitiveFilter(String text, Set<String> sensitiveWord, int matchType, String replaceChar) {
        if (CollectionUtils.isEmpty(sensitiveWord)) {
            return text;
        }
        Map<String, Object> sensitiveWordMap = SensitiveWordInit.addSensitiveWordToHashMap(sensitiveWord);
        if (matchType < 0 || matchType > 2) {
            matchType = 1;
        }
        if (StringUtils.trimToEmpty(replaceChar).equals(StringUtils.EMPTY)) {
            replaceChar = "*";
        }
        return replaceSensitiveWord(sensitiveWordMap, text, matchType, replaceChar);
    }

    /**
     * 替换敏感字字符
     *
     * @param txt
     * @param matchType
     * @param replaceChar 替换字符，默认*
     * @version 1.0
     */
    public static String replaceSensitiveWord(Map sensitiveWordMap, String txt, int matchType, String replaceChar) {
        String resultTxt = txt;
        //获取所有的敏感词
        Set<String> set = getSensitiveWord(sensitiveWordMap, txt, matchType);
        Iterator<String> iterator = set.iterator();
        String word = null;
        String replaceString = null;
        while (iterator.hasNext()) {
            word = iterator.next();
            replaceString = getReplaceChars(replaceChar, word.length());
            resultTxt = resultTxt.replaceAll(word, replaceString);
        }

        return resultTxt;
    }


    /**
     * 获取文字中的敏感词
     *
     * @param txt       文字
     * @param matchType 匹配规则&nbsp;1：最小匹配规则，2：最大匹配规则
     * @return
     * @version 1.0
     */
    public static Set<String> getSensitiveWord(Map sensitiveWordMap, String txt, int matchType) {
        Set<String> sensitiveWordList = new HashSet<String>();

        for (int i = 0; i < txt.length(); i++) {
            //判断是否包含敏感字符
            int length = checkSensitiveWord(sensitiveWordMap, txt, i, matchType);
            //存在,加入list中
            if (length > 0) {
                sensitiveWordList.add(txt.substring(i, i + length));
                //减1的原因，是因为for会自增
                i = i + length - 1;
            }
        }

        return sensitiveWordList;
    }

    /**
     * 获取替换字符串
     *
     * @param replaceChar
     * @param length
     * @return
     * @version 1.0
     */
    private static String getReplaceChars(String replaceChar, int length) {
        String resultReplace = replaceChar;
        for (int i = 1; i < length; i++) {
            resultReplace += replaceChar;
        }

        return resultReplace;
    }

    /**
     * 检查文字中是否包含敏感字符，检查规则如下：<br>
     *
     * @param txt
     * @param beginIndex
     * @param matchType
     * @return，如果存在，则返回敏感词字符的长度，不存在返回0
     * @version 1.0
     */
    public static int checkSensitiveWord(Map sensitiveWordMap, String txt, int beginIndex, int matchType) {
        //敏感词结束标识位：用于敏感词只有1位的情况
        boolean flag = false;
        //匹配标识数默认为0
        int matchFlag = 0;
        char word = 0;
        Map nowMap = sensitiveWordMap;
        for (int i = beginIndex; i < txt.length(); i++) {
            word = txt.charAt(i);
            //获取指定key
            nowMap = (Map) nowMap.get(word);
            //存在，则判断是否为最后一个
            if (nowMap != null) {
                //找到相应key，匹配标识+1
                matchFlag++;
                //如果为最后一个匹配规则,结束循环，返回匹配标识数
                if ("1".equals(nowMap.get("isEnd"))) {
                    //结束标志位为true
                    flag = true;
                    //最小规则，直接返回,最大规则还需继续查找
                    if (SensitivewordFilter.minMatchTYpe == matchType) {
                        break;
                    }
                }
            } else {     //不存在，直接返回
                break;
            }
        }
        //长度必须大于等于1，为词
        if (matchFlag < 1 || !flag) {
            matchFlag = 0;
        }
        return matchFlag;
    }


    /**
     * 判断文字是否包含敏感字符
     *
     * @param txt       文字
     * @param matchType 匹配规则 1：最小匹配规则，2：最大匹配规则
     * @return 若包含返回true，否则返回false
     */
    public static boolean contains(Map sensitiveWordMap, String txt, int matchType) {
        boolean flag = false;
        for (int i = 0; i < txt.length(); i++) {
            int matchFlag = checkSensitiveWord(sensitiveWordMap, txt, i, matchType); //判断是否包含敏感字符
            if (matchFlag > 0) {    //大于0存在，返回true
                //flag = true;
                return true;
            }
        }
        return flag;
    }
}