package com.yizhi.util.application.tree;

import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @Author: shengchenglong
 * @Date: 2018/5/18 11:04
 */
public class TreeUtil {

    /**
     * 根据集合组成一个树形结构
     *
     * @return
     */
    public static List<CommonTree> buildTree(List<CommonTree> list, Object topKey) {
        TreeBuilder treeBuilder = new TreeBuilder();
        return treeBuilder.treeList(list, topKey);
    }

    /**
     * 根据集合组成一个树形结构(自动发现rootId)
     *
     * @return
     */
    public static List<CommonTree> buildTree(List<CommonTree> list) {
        TreeBuilder treeBuilder = new TreeBuilder();
        return treeBuilder.treeList(list);
    }

    /**
     * 遍历一个树形结构，并返回所有节点
     *
     * @param trees
     * @return
     */
    public static List<CommonTree> traverseTree(List<CommonTree> trees) {
        TreeBuilder treeBuilder = new TreeBuilder();
        treeBuilder.traverseTree(trees);
        return treeBuilder.getDest();
    }

//    /**
//     * 遍历一个树形结构，并返回所有节点
//     * @param trees
//     * @return
//     */
//    public static List<CommonTree> traverseTreeRightLeft(List<CommonTree> trees) {
//        TreeBuilder treeBuilder = new TreeBuilder();
//        return treeBuilder.traverseTreeRightLeft(trees, new ArrayList<>(), 0);
//    }


    /**
     * 遍历一个树形结构(rootId = 0)，并组建左右Index
     *
     * @param trees
     * @return
     */
    public static List<CommonTree> buildAndTraverseRightLeftIndex(List<CommonTree> trees) {
        TreeBuilder treeBuilder = new TreeBuilder();
        treeBuilder.traverseTreeRightLeft(trees);
        List<CommonTree> dest = treeBuilder.getDest();
        if (dest.size() == 1) {
            dest.get(0).setRight(2);
        } else {
            for (CommonTree tree : dest) {
                if (null == tree.getRight()) {
                    if (CollectionUtils.isEmpty(tree.getChildren())) {
                        tree.setRight(tree.getLeft() + 1);
                    } else {
                        List<CommonTree> l = new ArrayList<>();
                        l.add(tree);
                        tree.setRight((TreeUtil.traverseTree(l).size() - 1) * 2 + tree.getLeft() + 1);
                    }
                }
            }
        }
        return dest;
    }

    /**
     * 遍历一个树形结构，并返回所有节点
     *
     * @param trees
     * @return
     */
    public static Set traverseTreeId(List<CommonTree> trees) {
        TreeBuilder treeBuilder = new TreeBuilder();
        treeBuilder.traverseTreeId(trees);
        return treeBuilder.getDestSet();
    }

    /**
     * 获取指定节点及其子节点
     *
     * @param allNodes
     * @param checkedIds
     * @return
     */
    public static List<CommonTree> getCheckedWithSub(List<CommonTree> allNodes, List checkedIds) {
        List<CommonTree> result = new ArrayList<>();
        if (!CollectionUtils.isEmpty(allNodes) && !CollectionUtils.isEmpty(checkedIds)) {
            for (CommonTree tree : allNodes) {
                if (checkedIds.contains(tree.getId())) {
                    result.add(tree);
                }
            }
        }
        if (!CollectionUtils.isEmpty(result)) {
            return traverseTree(result);
        }
        return null;
    }

    /**
     * 获取指定节点及其子节点id
     *
     * @param allNodes
     * @param checkedIds
     * @return
     */
    public static Set getCheckedWithSubId(List<CommonTree> allNodes, List checkedIds) {
        List<CommonTree> result = new ArrayList<>();
        if (!CollectionUtils.isEmpty(allNodes) && !CollectionUtils.isEmpty(checkedIds)) {
            for (CommonTree tree : allNodes) {
                if (checkedIds.contains(tree.getId())) {
                    result.add(tree);
                }
            }
        }
        if (!CollectionUtils.isEmpty(result)) {
            return traverseTreeId(result);
        }
        return null;
    }

    /**
     * 获取id节点下的子节点
     *
     * @param all
     * @param id
     * @return
     */
    public static CommonTree getChildList(List<CommonTree> all, Object id) {
        TreeBuilder treeBuilder = new TreeBuilder();
        return treeBuilder.getChildList(all, id);
    }
}
