站点维护脚本

-- ----------------------------
-- Table structure for site_protect 站点维护表
-- ----------------------------
CREATE TABLE `site_protect` (
  `id` bigint(20) NOT NULL,
  `name` varchar(100) NOT NULL COMMENT '维护名称',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '删除标识，0未删除 1已删除',
  `create_by_id` bigint(20) NOT NULL,
  `update_by_id` bigint(20) DEFAULT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `create_by_name` varchar(30) NOT NULL COMMENT '创建人name',
  `update_by_name` varchar(30) DEFAULT NULL,
  `close_flag` bit(1) NOT NULL DEFAULT b'0' COMMENT '关站通知标识 0没有 1有',
  `inner_flag` bit(1) NOT NULL DEFAULT b'0' COMMENT '站内通知标识 0没有 1有',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='站点维护信息表';


-- ----------------------------
-- Table structure for site_protect_notice  站点维护通知表
-- ----------------------------
CREATE TABLE `site_protect_notice` (
  `id` bigint(20) NOT NULL,
  `site_protect_id` bigint(20) NOT NULL COMMENT 'site_protect id',
  `notice_type` varchar(20) NOT NULL COMMENT '通知类型  INNER_NOTICE站内 CLOSE_NOTICE关站',
  `message` varchar(100) DEFAULT NULL COMMENT '通知内容',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `create_by_name` varchar(32) DEFAULT NULL,
  `update_by_name` varchar(32) DEFAULT NULL,
  `update_by_id` bigint(20) DEFAULT NULL,
  `create_by_id` bigint(20) DEFAULT NULL,
  `site_type` varchar(10) NOT NULL COMMENT '站点类型， ALL 所有站点， PART 自选站点',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '删除标识 0未删除  1已删除',
  `start_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `end_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `idx_notice_protect_id` (`site_protect_id`) USING BTREE COMMENT 'site_protect_id索引'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



-- ----------------------------
-- Table structure for site_protect_rel  站点维护 站点关联表
-- ----------------------------
CREATE TABLE `site_protect_rel` (
  `id` bigint(20) NOT NULL,
  `site_protect_id` bigint(20) NOT NULL COMMENT '维护信息id',
  `site_id` bigint(20) NOT NULL COMMENT '站点id',
  `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '删除标识，0未删除 1已删除',
  `create_by_id` bigint(20) NOT NULL,
  `update_by_id` bigint(20) DEFAULT NULL,
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `update_time` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `create_by_name` varchar(30) NOT NULL,
  `update_by_name` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_site_protect_rel` (`site_protect_id`,`site_id`) USING BTREE COMMENT '站点维护信息关联索引'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='站点维护信息表';

## 配置修改
###  cloud-system 
--  bootstrap.properties
++ 新增
mybatis-plus.global-config.logic-not-delete-value=0
mybatis-plus.global-config.logic-delete-value=1
mybatis-plus.global-config.sql-injector=com.baomidou.mybatisplus.mapper.LogicSqlInjector








