package com.yizhi.exam.application.feign;

import java.util.Map;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.exam.application.vo.CalendarTaskParamVo;
import com.yizhi.exam.application.vo.ExamAnswerApiListVO;
import com.yizhi.exam.application.vo.ExamCalendarVO;
import com.yizhi.exam.application.vo.MyExamParameterVO;
import com.yizhi.exam.application.vo.dashboard.ExamDashboardQueryVO;
import com.yizhi.exam.application.vo.exam.ExamDetailsVO;
import com.yizhi.exam.application.vo.exam.ExamResultVO;
import com.yizhi.exam.application.vo.exam.PcCardVO;
import com.yizhi.exam.application.vo.exam.PcStudentExamAnswerVo;
import com.yizhi.exam.application.vo.exam.StudentExamAnswerVo;

import io.swagger.annotations.ApiParam;

/**
 * 〈一句话功能简述〉<br>
 * 〈学员端接口〉
 *
 * @author fanchunhui
 * @create 2018/3/28
 * @since 1.0.0
 */
@FeignClient(name = "exam", contextId = "ExamApiClient")
public interface ExamApiClient {

    @PostMapping("/api/exam/result")
    ExamAnswerApiListVO getExamResultList(@RequestBody ExamAnswerApiListVO examAnswerApiListVo);

    @PostMapping("/api/exam/details")
    ExamDetailsVO examDetail(@RequestBody ExamAnswerApiListVO examAnswerApiListVo);

    @GetMapping("/api/exam/count")
    Integer selectCountByAccountId(@RequestParam("accountId") Long accountId);

    /**
     * 学员考试答卷查看
     *
     * @param pageNo
     * @param pageSize
     * @param accountId
     * @param answerId
     * @return
     */
    @GetMapping("/api/exam/show/my/answer")
    StudentExamAnswerVo showMyExamAnswer(@RequestParam("pageNo") Integer pageNo, @RequestParam("pageSize") Integer pageSize,
                                         @RequestParam("type") Integer type, @RequestParam("accountId") Long accountId, @RequestParam("answerId") Long answerId);

    /**
     * pc端学员考试答卷查看
     *
     * @param type
     * @param accountId
     * @param answerId
     * @return
     */
    @GetMapping("/api/exam/show/my/pcAnswer")
    PcStudentExamAnswerVo showMyPcExamAnswer(@RequestParam("type") Integer type, @RequestParam("accountId") Long accountId, @RequestParam("answerId") Long answerId);

    /**
     * pc端学员考试答卷答题卡
     *
     * @param pageNo
     * @param pageSize
     * @param answerId
     * @return
     */
    @GetMapping("/api/exam/show/my/pcAnswerCard")
    PcCardVO showMyPcExamAnswerCards(@RequestParam("pageNo") Integer pageNo, @RequestParam("pageSize") Integer pageSize,
                                     @RequestParam("answerId") Long answerId);

    /**
     * 学员考试结果页查看（考试结束后）
     *
     */
    @GetMapping("/api/exam/show/my/answer/result")
    ExamResultVO showMyExamResult(@RequestParam("accountId") Long accountId, @RequestParam("examId") Long examId);

    /**
     * 扫描二维码参加考试
     *
     */
    @PostMapping("/api/exam/code/scan")
    ExamDetailsVO scanCodeExam(@RequestBody MyExamParameterVO myExamParameterVO);

    @PostMapping("/api/exam/getPageToCalendar")
    public Page<ExamCalendarVO> getPageToCalendar(@ApiParam("paramVo") @RequestBody CalendarTaskParamVo paramVo);
    
    @PostMapping("/api/exam/dashboard/duration/get")
    public Map<Long, Integer> getExamDashboardData(@RequestBody ExamDashboardQueryVO query);
}