/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: ExamClient
 * Author:   phone
 * Date:     2018/3/21 10:50
 * Description: 考试接口
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.feign;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.exam.application.vo.*;
import com.yizhi.exam.application.vo.domain.Exam;
import com.yizhi.exam.application.vo.domain.TrExamPoint;
import com.yizhi.exam.application.vo.exam.ExamIdVO;
import com.yizhi.exam.application.vo.exam.QuestionSortVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br>
 * 〈考试接口〉
 *
 * @author fanchunhui
 * @create 2018/3/21
 * @since 1.0.0
 */
@FeignClient(name = "exam", contextId = "ExamClient")
public interface ExamClient {

    /**
     * 显示考试信息列表
     */
    @GetMapping("/manage/exam/list")
    Map<String, Object> getExamList(@RequestParam(value = "currentTime", required = false) String currentTime, @RequestBody ContextAndPageSizeVO contextAndPageSizeVO);

    @GetMapping("/manage/exam/experiencePoolList")
    Page<Map<String, Object>> getPoolExamList(@RequestParam(value = "name", required = false) String name,
                                              @RequestParam(value = "ids", required = false) List<Long> ids,
                                              @RequestParam(value = "pageNo", required = false) Integer pageNo,
                                              @RequestParam(value = "pageSize", required = false) Integer pageSize);

    @GetMapping("/manage/exam/count/list")
        // 统计列表和阅卷列表其实是一样的
    Map<String, Object> countList(@RequestParam("name") String name, @RequestParam("pageSize") Integer pageSize,
                                  @RequestParam("pageNo") Integer pageNo, @RequestParam(name = "companyId", required = false) Long companyId);

    @PostMapping("/manage/exam/deletes")
    Boolean deleteExam(@RequestBody Long[] idArr);

    @PostMapping("/manage/exam/put/up")
    Boolean examPutUp(@RequestBody ExamIdVO examIdVO);

    @PostMapping("/manage/exam/put/down")
    Boolean examPutDown(@RequestBody ExamIdVO examIdVO);

    @PostMapping("/manage/exam/export/answer")
    List<QuestionExamVO> exportAnswer(@RequestParam("examId") Long examId);

    @PostMapping("/manage/exam/count/account")
    Map<String, Object> getExamAnswers(@RequestParam("examId") Long examId, @RequestParam("pageNo") Integer pageNo,
                                       @RequestParam("pageSize") Integer pageSize, @RequestParam("accountIdList") List<Long> accountIdList,
                                       @RequestParam("orgIdList") List<Long> orgIdList, @RequestParam("state") Integer state,
                                       @RequestParam("tstart") String tstart, @RequestParam("tend") String tend);

    /**
     * 考试查看
     */
    @GetMapping("/manage/exam/view")
    ExamViewVO selectExam(@RequestParam("examId") Long examId);
    // ExamModelVO examView(@RequestParam("examId")Long examId,
    // @RequestParam("pageNo")Integer pageNo,@RequestParam("pageSize") Integer
    // pageSize);

    /**
     * 导入考试试题
     */
    @GetMapping("/manage/exam/question/export")
    boolean insertByFile(@RequestParam("fileDir") String fileDir, @RequestParam("fileName") String fileName,
                         @RequestParam("id") Long id);

    /**
     * 获取考试表信息
     *
     * @param examId
     * @return
     */
    @GetMapping("/manage/exam/view/info")
    Exam examViewInfo(@RequestParam("examId") Long examId);

    @PostMapping(value = "/manage/exam/insert/question/sort")
    boolean insertQuestionSort(@RequestBody QuestionSortVO questionSortVO);

    /**
     * 获取考试信息
     *
     * @param examId 考试
     * @return
     */
    @GetMapping("/manage/exam/info")
    Exam selectExamById(@RequestParam("examId") Long examId);

    /**
     * 首页搜索考试信息
     *
     * @param keyWord   查询关键字
     * @param pageNo    页码
     * @param pageSize  每页页数
     * @param accountId 员工号
     * @param companyId 企业号
     * @param siteId    站点ID
     * @param orgId     组织
     * @return
     */
    @GetMapping("/manage/exam/search/")
    Page<Exam> selectExamLikeName(@RequestParam(name = "keyWord", required = false) String keyWord, @RequestParam("pageNo") Integer pageNo,
                                  @RequestParam("pageSize") Integer pageSize,
                                  @RequestParam(name = "accountId", required = true) Long accountId,
                                  @RequestParam(name = "companyId", required = true) Long companyId,
                                  @RequestParam(name = "siteId", required = true) Long siteId,
                                  @RequestParam(name = "orgId", required = true) Long orgId);

    /**
     * 获取考试信积分信息
     *
     * @param examId    考试号
     * @param companyId 企业号
     * @param siteId    站点ID
     * @param orgId     组织
     * @return
     */
    @GetMapping("/manage/exam/point/")
    List<TrExamPoint> selectExamPointInfo(@RequestParam(name = "examId", required = true) Long examId,
                                          @RequestParam(name = "companyId", required = true) Long companyId,
                                          @RequestParam(name = "siteId", required = true) Long siteId,
                                          @RequestParam(name = "orgId", required = true) Long orgId);

    /**
     * 根据考试名称查询考试信息
     */
    @GetMapping("/manage/exam/listByName")
    List<Exam> selectExamListByName(@RequestBody ContextAndPageSizeVO contextAndPageSizeVO);

    @GetMapping("/manage/exam/selectExamListBySta")
    ExamDetailsMarkingVO selectExamListBySta(@RequestBody ContextAndPageSizeVO contextAndPageSizeVO);

        /**
         * 根据考试名称获取总数
         */
    @GetMapping("/manage/exam/listByName/count")
    int selectExamListByNameCount(@RequestBody ContextAndPageSizeVO contextAndPageSizeVO);

    /**
     * 获取该考试名称是否存在
     */
    @GetMapping("/manage/exam/name/exist")
    boolean nameIsExist(@RequestParam("name") String name);

    /**
     * 根据企业ID 部门ID 站点ID获取考试列表
     */
    @GetMapping("/manage/exam/context/list")
    List<Exam> selectExamByContext(@RequestParam("companyId") Long companyId, @RequestParam("orgId") Long orgId,
                                   @RequestParam("siteId") Long siteId, @RequestParam("name") String name);

    /**
     * 按考试统计考试信息列表查询
     */
    @GetMapping("/exam/export")
    List<Exam> selectExamListByNameExport(@RequestParam("name") String name, @RequestParam("companyId") Long companyId);

    @PostMapping("/manage/exam/statistical/examByUser")
    Page<StatisticalByUserVO> examByUser(@RequestBody ExamCountByUserVO vo);

    @PostMapping("/manage/exam/statistical/selectExamByName")
    List<Exam> selectExamByName(@RequestBody ExamCountExportParamVO vo);

    @PostMapping("/manage/exam/statistical/examAnswerByExamId")
    List<StatisticalByUserVO> examAnswerByExamId(@RequestBody ExamCountByUserVO ecvo);

    @GetMapping(value = "/manage/exam/score/check", produces = "text/html;charset=UTF-8")
    String checkScore(@RequestParam("examId") Long examId);


    @GetMapping("/manage/exam/by/new/server")
    public List<Map<String, Object>> getServerByCompanyIdAndIds(@RequestParam("companyId") Long companyId, @RequestParam(name = "ids", required = false) List<Long> ids);

    /**
     * 查找考试完成的学员id
     *
     * @param examId
     * @param companyId
     * @param siteId
     * @return
     */
    @GetMapping("/manage/exam/getFinishedIds")
    public List<Long> getFinishedAccountIds(@RequestParam("examId") Long examId, @RequestParam("companyId") Long companyId, @RequestParam("siteId") Long siteId);

    @GetMapping("/manage/exam/visibleRange")
    public List<TrExamAuthorizeVO> VisibleRange(@RequestParam("examId") Long examId);

    /**
     * 查找七内结束的考试
     *
     * @return
     */
    @GetMapping("/remote/exam/expireList")
    public List<Exam> getExpireList();

    /**
     * 查找多门考试,该考生
     *
     * @param examIds
     * @return
     */
    @PostMapping("/manage/exam/getMaxScores")
    public Map<Long, Map<String, Object>> getMaxScores(@RequestBody List<Long> examIds);
}
