/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: ExamQuestionApiClient
 * Author:   phone
 * Date:     2018/3/28 14:28
 * Description: 试卷生成学员端
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.feign;

import com.yizhi.exam.application.vo.exam.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 〈一句话功能简述〉<br>
 * 〈试卷生成学员端〉
 *
 * @author fanchunhui
 * @create 2018/3/28
 * @since 1.0.0
 */
@FeignClient(name = "exam", contextId = "ExamQuestionApiClient")
public interface ExamQuestionApiClient {

    /**
     * 根据考试的设置，生成空白答卷（题目、答案选项）
     *
     * @return 返回考生考试试卷
     */
    @PostMapping("/api/exam/make")
    StudentExamPaperVO makeExamQuestion(@RequestBody StudentExamPaperVO studentExamPaperVO);

    /**
     * pc端考卷生成,开始考试/继续考试
     *
     * @param studentExamPaperVO
     * @return
     */
    @PostMapping("/api/exam/pcMake")
    PcStudentExamPaperVo makePcExamQuestion(@RequestBody StudentExamPaperVO studentExamPaperVO);

    @PostMapping("/api/exam/continue")
    StudentExamPaperVO examContinue(@RequestBody ExamPaperVO examPaperVO);

    @PostMapping("/api/exam/save")
    boolean saveExamAnswer(@RequestBody ExamAnswerVO vo);

    @PostMapping("/api/exam/submit")
    ExamResultVO submitExamPage(@RequestBody ExamAnswerVO vo);

    @PostMapping("api/exam/mark")
    boolean mark(@RequestBody ExamAnswerVO examAnswerVO);

    @PostMapping("api/exam/history")
    List<ExamHistoryVO> selectHistory(@RequestParam("examId") Long examId, @RequestParam("accountId") Long accountId);

    /**
     * 提交考试失效的考试信息
     * @param examAnswerApiListVo
     * @return
     */
    @PostMapping("/api/exam/lose/submit")
    ExamResultVO submitExamLose(@RequestBody ExamAnswerVO vo);

    /**
     * 任务调度提交考试失效的考试信息
     * @param companyId 企业ID
     */
    @PostMapping("/api/exam/job/lose/submit")
    void jobSubmitExamLose(@RequestBody ExamAnswerVO answerVo);

    /**
     * 获取一场考试剩余考试时间
     * @param vo
     * @return
     */
    @PostMapping("/api/exam/getRemainderTime")
    Integer getRemainderTime(@RequestBody ExamAnswerVO vo);

    /**
     * pc/微信端学员答卷答题卡
     * @param answerId
     * @return
     */
    @GetMapping("/api/exam/getMyExamAnswerCards")
    List<CardVO> getMyExamAnswerCards(@RequestParam("answerId") Long answerId);

}
