package com.yizhi.exam.application.vo;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "AddQuestionVO", description = "添加试题")
@Data
public class AddQuestionVO {

	@ApiModelProperty(value = "主键ID")
	private Long id;

	@ApiModelProperty(value = "系统出题_出题策略，1手动出题（每个学员使用同一份试卷） 2系统出题（每个学员使用不同试卷）")
	private Integer sysMakeStrategy;

	@ApiModelProperty(value = "题干排序，1默认排序 2题型排序 3随机排序")
	private Integer stemSort;

	@ApiModelProperty(value = "选项排序，1默认排序 2随机排序")
	private Integer optionSort;

	@ApiModelProperty(value = "试题列表")
	private List<ExamQuestionVO> examQuestionVoList;

	@ApiModelProperty(value = "系统出题规则")
	private List<TrExamSystemQuestionVO> trExamSystemQuestionVoList;

	@ApiModelProperty(value = "题型排序")
	private List<TrExamQuestionSortVO> trExamQuestionSortVoList;

	@ApiModelProperty("用户ID")
	Long accountId;

	@ApiModelProperty("用户名")
	String accountName;
}
