package com.yizhi.exam.application.vo;

import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "ExamQuestionLibraryVO", description = "")
@Data
public class ExamQuestionLibraryVO {
	
	@ApiModelProperty(value = "分数")
	private BigDecimal score;
	
	@ApiModelProperty(value = "考试题目ID，主键")
	private Long id;
	
	@ApiModelProperty(value = "总数")
	private Long total;
	
	@ApiModelProperty(value = "题干，题目内容")
	private String stem;
	
	@ApiModelProperty(value = "题型，1单选题、2多选题、3判断题、4问答题")
	private Integer type;
	
	@ApiModelProperty(value = "题库ID")
	private Long libraryId;
	
	@ApiModelProperty(value = "题目状态")
	private Integer status;

	@ApiModelProperty(value = "是否删除：0删除1有效")
	private Integer state;
	
	
	@ApiModelProperty(value="上一题ID")
	private Long prevId=-1L;
	
	@ApiModelProperty(value="下一题ID")
	private Long nextId=-1L;
}
