package com.yizhi.exam.application.vo;

import com.yizhi.exam.application.vo.MessageRemindVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@ApiModel(value = "ExamStrategyVo", description = "考试策略")
@Data
public class ExamStrategyVO {
	
	@ApiModelProperty(value="主键ID")
	private Long id;
	
	@ApiModelProperty(value = "考试范围，1平台用户可见 2指定用户可见")
	private Integer visibleRange;

	@ApiModelProperty(value = "呈现样式，1整页呈现 2逐题呈现")
	private Integer pageMode;

	@ApiModelProperty(value = "显示答卷，0不显示 1交卷后显示 2考试结束后显示")
	private Integer isAnswerPaper;

	@ApiModelProperty(value = "显示成绩，0不显示 1交卷后显示 2考试结束后显示")
	private Integer isScore;

	@ApiModelProperty(value = "显示答案，0不显示 1交卷后显示 2考试结束后显示")
	private Integer isAnswer;

	@ApiModelProperty(value = "显示解析，0不显示 1交卷后显示 2考试结束后显示")
	private Integer isAnalysis;

	@ApiModelProperty(value = "显示通用分评价，0不显示 1交卷后显示 2考试结束后显示")
	private Integer isPaperid;

	@ApiModelProperty(value = "是否使用积分，0不使用 1使用，默认0")
	private Integer isPoint;

	@ApiModelProperty(value = "提醒设置，0否 1是，默认0")
	private Integer remind;

	@ApiModelProperty(value = "考试人员范围")
	private List<TrExamAuthorizeVO> trExamAuthorizeVoList;

	@ApiModelProperty(value = "考试分数通用评价")
	private List<TrExamScoreEvaluateVO> trExamScoreEvaluateVoList;

	@ApiModelProperty(value = "考试积分")
	private List<TrExamPointVO> trExamPointVoList;

	@ApiModelProperty(value = "提醒设置")
	private TrExamRemindVO trExamRemindVO;

	@ApiModelProperty(value = "可见范围类型1部门2用户组")
	private Integer orgType;

	@ApiModelProperty(value = "平台用户可见时传部门ID过来")
	private Long orgId;

	@ApiModelProperty(value = "平台用户可见时传站点ID过来")
	private Long siteId;

	@ApiModelProperty(value = "合格分，本次考试的合格分")
	private Integer qualifiedScore;

	@ApiModelProperty("用户名")
	private String accountName;

	@ApiModelProperty("用户ID")
	private Long accountId;

	@ApiModelProperty(value = "各个业务设置提醒时的数据")
	private MessageRemindVo messageRemindVo;

	@ApiModelProperty(value = "是否启用在日历任务中显示 1:显示 0：")
	private Integer enableTask;
}
