package com.yizhi.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.application.domain.QuestionLibrary;
import com.yizhi.exam.application.vo.ContextAndPageSizeVO;
import com.yizhi.exam.application.vo.ListLibraryVO;
import com.yizhi.exam.application.vo.TypeAndCountVo;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 * 题库 Mapper 接口
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface QuestionLibraryMapper extends BaseMapper<QuestionLibrary> {

    @Select("select * from question_library where state=1 limit #{start},#{end}")
    List<QuestionLibrary> getQuestionLibraryList(@Param("start") Integer start, @Param("end") Integer end);


    @Select("select count(*) from question_library where state in (1,2) and site_id=#{siteId} order by create_time desc")
    Integer sumNum(@Param("siteId") Long siteId);

    int libraryState(@Param("subjectId") Long subjectId);

    int questionState(@Param("questionId") Long questionId, @Param("companyId") Long companyId, @Param("orgId") Long orgId,
                      @Param("siteId") Long siteId);

	List<ListLibraryVO> listLibrary(@Param("contextAndPageSizeVO") ContextAndPageSizeVO contextAndPageSizeVO, @Param("managerIds")List<Long> managerIds);

	Integer listLibraryVOCount(@Param("contextAndPageSizeVO") ContextAndPageSizeVO contextAndPageSizeVO,@Param("managerIds")List<Long> managerIds);

    /**
     * 查询试题是否被考试使用
     *
     * @param subjectId
     * @return
     */
    int examCountBySubjectId(@Param("subjectId") Long subjectId);

    /**
     * 获得各个题库每个题型的个数
     * @param ids
     * @return
     */
    List<TypeAndCountVo> selectTypeAndCount(@Param("ids") List<Long> ids);

    List<TypeAndCountVo> getTypeAndCount(@Param("examId") Long examId, @Param("libraryId") Long libraryId);
}
