package com.yizhi.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.application.domain.TrExamOnlineReadOver;
import com.yizhi.exam.application.vo.*;
import com.yizhi.exam.application.vo.exam.ReadOnLineExamExportVO;
import com.yizhi.exam.application.vo.UserInfoVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 考试阅卷 Mapper 接口
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface TrExamOnlineReadOverMapper extends BaseMapper<TrExamOnlineReadOver> {

	PaperInspectionVo findByParam(@Param(value="id")Long id);

	/**
	 *
	 * @param examId
	 * @param accountIdList
	 * @param start
	 * @param end
	 * @return
	 */
	List<TrExamOnlineReadOver> listTrExamOnlineReadOver(@Param(value="examId")Long examId,@Param(value="accountIdList")List<Long> accountIdList,@Param(value="start")Integer start,@Param(value="end")Integer end);

	/**
	 * 数量
	 * @param examId
	 * @param accountIdList
	 * @param start
	 * @param end
	 * @return
	 */
	Integer likeListSum(@Param(value="examId")Long examId,@Param(value="accountIdList")List<Long> accountIdList,@Param(value="start")Integer start,@Param(value="end")Integer end);

	/**
	 * 阅卷的题目信息

	 */
	List<ExamQuestionSubjectVo>  findQuestionByParam(@Param(value="id")Long id);

	/**
	 * 获取阅卷列表
	 * */
	/*@Select("SELECT account_id AS accountId,b.name AS userName,b.full_name AS NAME,c.name AS depart,state,sum_score AS sumScore,objective_score AS objectiveScore,subjective_score AS subjectiveScore \n" +
			"FROM cloud_exam.tr_exam_online_read_over AS a \n" +
			"LEFT JOIN cloud_security.account b ON id = a.account_id\n" +
			"LEFT JOIN cloud_security.organization c ON c.id = b.org_id\n" +
			"WHERE exam_id = #{examId} AND state > 0 LIMIT #{start},#{end};")*/
	List<ExamOnlineReadOverVo> selectList(@Param("accountIds") List<Long> accountIds, @Param(value="examId")Long examId, @Param(value="start")Integer start, @Param(value="end")Integer end, @Param(value="userInfoVOMap")Map<Long,UserInfoVO> userInfoVOMap);

	List<ExamOnlineReadOverVo> selectStateList(@Param(value="examId")Long examId,@Param(value = "accountId")Long accountId);

	Integer selectListCount(@Param("accountIds") List<Long> accountIds, @Param(value = "examId") Long examId, @Param(value = "userInfoVOMap") Map<Long, UserInfoVO> userInfoVOMap);

//	@Select("SELECT a.read_over_id AS readOverId,a.sum_num AS sumNum,b.name AS examName,a.objective_score AS objectiveScore,a.subjective_score AS subjectiveScore, \n" +
//			"a.sum_score AS sumScore,\n" +
//			"CASE WHEN a.state = 2 THEN CASE WHEN (a.sum_score>=b.qualified_score)" +
//			" THEN '1' ELSE '0' END END AS isQualified,\n"+
//			"a.account_id AS accountId,exam_answer_id as examAnswerId\n" +
//			"FROM tr_exam_online_read_over a\n" +
//			"LEFT JOIN exam b ON b.id = a.exam_id\n" +
//			"where read_over_id = #{readOverId}")
	MarkStudentVO selectReadOverById(@Param("readOverId") Long readOverId);

//	@Select("SELECT c.id AS questionId,d.stem,a.answer,d.analysis,c.score,IFNULL(e.score,f.score) AS questionScore,c.exam_question_id FROM tr_exam_answer_question_res_ma a\n" +
//			"\t\t\tLEFT JOIN tr_exam_online_read_over b ON b.exam_answer_id = a.answer_id\n" +
//			"\t\t\tLEFT JOIN tr_exam_answer_question c ON c.answer_id = b.exam_answer_id AND c.id = a.answer_question_id\n" +
//			"\t\t\tLEFT JOIN tr_question_library_subject d ON d.id = c.subject_id \n" +
//			"\t\t\tLEFT JOIN tr_exam_question e ON e.id = c.exam_question_id AND e.exam_id = b.exam_id \n" +
//			"\t\t\tLEFT JOIN tr_exam_system_question f ON f.exam_id = b.exam_id and f.type = 4 \n" +
//			"\t\t\tWHERE b.read_over_id = #{readId}")
	List<MarkStudentQuestionVO> selectQuestionByAnswerId(@Param("readId") Long readId);

	/**
	 * 根据答卷ID获取阅卷信息
	 * @param examAnswerId
	 * @return
	 */
	TrExamOnlineReadOver getExamOnlineReadOverByExamAnswerId(@Param("examAnswerId") Long examAnswerId);


	int getReadCount(@Param("examId") Long examId);

	/**
	 * 管理端阅卷管理考试结果查看
	 * @param examId
	 * @param accountIds
	 * @return
	 */
	List<ReadOnLineExamExportVO> studentExamExport(@Param("examId") Long examId,@Param("accountIds") List<Long> accountIds);

	/**
	 * 阅卷管理加上合格人数
	 * @param examIds
	 * @return
	 */
	List<QualifiedNumVO> getQualifiedNum(@Param("examIds") List<Long> examIds);
}
