package com.yizhi.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.application.domain.TrExamSystemQuestion;
import com.yizhi.exam.application.vo.ShowExamQuestionVO;
import com.yizhi.exam.application.vo.TrExamSystemQuestionVO;
import com.yizhi.exam.application.vo.exam.SumQuestionVO;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 * 系统出题规则 Mapper 接口
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface TrExamSystemQuestionMapper extends BaseMapper<TrExamSystemQuestion> {

	List<TrExamSystemQuestionVO> listTrExamSystemQuestion(Long examId);

	SumQuestionVO selectSumQuestionAndScore(Long examId);

	@Select("SELECT c.TYPE AS TYPE,SUM(c.numSum) AS numSum,SUM(c.score) AS score FROM (\n" +
			"SELECT b.type AS TYPE,COUNT(a.id) AS numSum,IFNULL(SUM(a.score),0) AS score FROM tr_exam_question a\n" +
			"LEFT JOIN tr_question_library_subject b ON b.id = a.subject_id\n" +
			"WHERE exam_id = #{examId} AND a.state = 1 GROUP BY b.type\n" +
			"UNION ALL\n" +
			"SELECT TYPE AS TYPE,SUM(num) AS numSum,SUM(score * num) AS score FROM tr_exam_system_question WHERE state = 1 AND exam_id = #{examId} GROUP BY TYPE\n" +
			") c GROUP BY c.type")
	List<ShowExamQuestionVO> selectExamSystemQuestionScoreAndNum(@Param("examId") Long examId);

	/**
	 * 查询所有题库ID去重
	 * */
	@Select("SELECT library_id FROM tr_exam_system_question where exam_id = #{examId} and state = 1 GROUP BY library_id")
	List<Long> selectLibraryIdByExamId(@Param("examId") Long examId);

	@Select("select id,type,num as numSum,score from tr_exam_system_question where exam_id = #{examId} and library_id = #{libraryId}  and state = 1")
	List<ShowExamQuestionVO> selectSystemQuestionByExamIdAndLibraryId(@Param("examId") Long examId,@Param("libraryId") Long libraryId);

	/**
	 * 获取系统出题题数
	 * @param examId
	 * @return
	 */
	Integer getSystemQestionCount(@Param("examId") Long examId);
}
