package com.yizhi.application.service;


import com.baomidou.mybatisplus.plugins.Page;
import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.StatisticsExamMetadata;
import com.yizhi.exam.application.vo.domain.StatisticsExamLearnMetadata;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 考试报表统计实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface IStatisticsExamMetadataService extends IService<StatisticsExamMetadata> {
	/**
	 * 批量插入学习记录
	 * @param examId 考试ID
	 * @param curDate 考试日期
	 * @return 返回考试的学生ID集合
	 */
	List<StatisticsExamLearnMetadata> insertAccountLearn(Long examId, String curDate);
	
	/**
	 * 查询统计考试信息，分页查询 
	 * @param paramMap
	 * @param pageNo
	 * @param pageSize
	 * @return
	 */
	Page<Long> selectAccountLearnList(Map<String, Object> paramMap, int pageNo, int pageSize);	
}
