package com.yizhi.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.constant.ExamConstant;
import com.yizhi.application.domain.TrExamScoreEvaluate;
import com.yizhi.application.mapper.TrExamScoreEvaluateMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.ITrExamScoreEvaluateService;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.exam.application.vo.TrExamScoreEvaluateVO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * <p>
 * 考试分数通用评价 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class TrExamScoreEvaluateServiceImpl extends ServiceImpl<TrExamScoreEvaluateMapper, TrExamScoreEvaluate>
		implements ITrExamScoreEvaluateService {

	@Autowired
	private IdGenerator idGenerator;


	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public List<TrExamScoreEvaluateVO> listTrExamScoreEvaluate(Long examId) {
		List<TrExamScoreEvaluateVO> list = new ArrayList<TrExamScoreEvaluateVO>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("exam_id", examId);
		map.put("state",1);
		map.put("state", ExamConstant.FIRST);
		List<TrExamScoreEvaluate> selectByMap = this.selectByMap(map);
		TrExamScoreEvaluateVO vo = null;
		for (TrExamScoreEvaluate te : selectByMap) {
			vo = new TrExamScoreEvaluateVO();
			vo.setId(te.getId());
			vo.setExamId(examId);
			vo.setMinScore(te.getMinScore());
			vo.setMaxScore(te.getMaxScore());
			vo.setDescription(te.getDescription());
			vo.setState(te.getState());
			list.add(vo);
		}
		return list;
	}

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean updateTrExamScoreEvaluateList(List<TrExamScoreEvaluateVO> trExamScoreEvaluateVoList, Long examId) {
		TrExamScoreEvaluate trExamScoreEvaluate =new TrExamScoreEvaluate();
		trExamScoreEvaluate.setExamId(examId);
		EntityWrapper<TrExamScoreEvaluate> wrapper=new EntityWrapper<TrExamScoreEvaluate>(trExamScoreEvaluate);
		this.delete(wrapper);
		List<TrExamScoreEvaluate> list = new ArrayList<TrExamScoreEvaluate>();
		TrExamScoreEvaluate tese = null;
		for(TrExamScoreEvaluateVO vo : trExamScoreEvaluateVoList){
			tese=new TrExamScoreEvaluate();
			tese.setId(idGenerator.generate());
			tese.setExamId(examId);
			tese.setMinScore(vo.getMinScore());
			tese.setMaxScore(vo.getMaxScore());
			tese.setDescription(vo.getDescription());
			tese.setState(ExamConstant.FIRST);
			setInsertCloumn(tese, true);
			list.add(tese);
		}
		this.insertBatch(list);
		/*List<TrExamScoreEvaluate> list = new ArrayList<TrExamScoreEvaluate>();
		List<TrExamScoreEvaluate> updateList = new ArrayList<TrExamScoreEvaluate>();
		TrExamScoreEvaluate tese = null;
		for (TrExamScoreEvaluateVO vo : trExamScoreEvaluateVoList) {
			tese = new TrExamScoreEvaluate();
			if (vo.getId() == null) {
				tese.setId(idGenerator.generate());
				tese.setExamId(examId);
				tese.setMinScore(vo.getMinScore());
				tese.setMaxScore(vo.getMaxScore());
				tese.setDescription(vo.getDescription());
				tese.setState(ExamConstant.FIRST);
				setInsertCloumn(tese, true);
				list.add(tese);
			} else {
				tese = this.selectById(vo.getId());
				if (null != tese){
					tese.setMinScore(vo.getMinScore());
					tese.setMaxScore(vo.getMaxScore());
					tese.setDescription(vo.getDescription());
					tese.setState(vo.getState());
					setInsertCloumn(tese, false);
					updateList.add(tese);
				}
			}
		}
		if (list.size() > 0) {
			this.insertBatch(list);
		}
		if (updateList.size() > 0) {
			this.updateBatchById(updateList);
		}*/
		return true;
	}

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean copyTrExamScoreEvaluate(Long oldId, Long examId) {
		List<TrExamScoreEvaluate> list = new ArrayList<TrExamScoreEvaluate>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("state", ExamConstant.FIRST);
		map.put("exam_id", oldId);
		List<TrExamScoreEvaluate> selectByMap = this.selectByMap(map);
		TrExamScoreEvaluate tq = null;
		for (TrExamScoreEvaluate te : selectByMap) {
			tq = new TrExamScoreEvaluate();
			BeanUtils.copyProperties(te, tq);
			tq.setId(idGenerator.generate());
			tq.setExamId(examId);
			setInsertCloumn(tq, true);
			list.add(tq);
		}
		if (list.size() > 0) {
			this.insertBatch(list);
		}
		return true;
	}

	public void setInsertCloumn(TrExamScoreEvaluate tq, boolean boo) {
		Long accountId = null;
		String accountName = null;
		RequestContext requestContext = ContextHolder.get();
		if (null != requestContext) {
			if (null != requestContext.getAccountId()) {
				accountId = requestContext.getAccountId();
			}
			if (null != requestContext.getAccountName()) {
				accountName = requestContext.getAccountName();
			}
		}
		accountId = 9999L;
		accountName = "bob";

		if (boo) {
			tq.setCreateById(accountId);
			tq.setCreateByName(accountName);
			tq.setCreateTime(new Date());
			tq.setUpdateById(accountId);
			tq.setUpdateByName(accountName);
			tq.setUpdateTime(new Date());
		} else {
			tq.setUpdateById(accountId);
			tq.setUpdateByName(accountName);
			tq.setUpdateTime(new Date());
		}
	}
	
	@Override
	public boolean insertAll(List<TrExamScoreEvaluate> trExamScoreEvaluates) {
		return this.insertBatch(trExamScoreEvaluates);
	}

}