package com.yizhi.application.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.yizhi.application.constant.ExamConstant;
import com.yizhi.application.domain.QuestionLibrary;
import com.yizhi.application.mapper.QuestionLibraryMapper;
import com.yizhi.exam.application.vo.*;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.TrExamSystemQuestion;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.mapper.TrExamSystemQuestionMapper;
import com.yizhi.application.orm.id.IdGenerator;
import com.yizhi.application.service.ITrExamSystemQuestionService;

/**
 * <p>
 * 系统出题规则 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class TrExamSystemQuestionServiceImpl extends ServiceImpl<TrExamSystemQuestionMapper, TrExamSystemQuestion>
		implements ITrExamSystemQuestionService {

	@Autowired
	private TrExamSystemQuestionMapper trExamSystemQuestionMapper;

	@Autowired
	private QuestionLibraryMapper questionLibraryMapper;

	@Autowired
	private IdGenerator idGenerator;

	public List<TrExamSystemQuestionVO> listTrExamSystemQuestion(Long examId) {
		return trExamSystemQuestionMapper.listTrExamSystemQuestion(examId);
	}

	/**
	 * 创建系统出题规则
	 * */
	@Override
	public boolean insertAll(ExamSystemQuestionVO examSystemQuestionVO) {
		List<ExamSystemQuestionVOS> examSystemQuestionVOS = examSystemQuestionVO.getExamSystemQuestionVOSList();
		TrExamSystemQuestion trExamSystemQuestion;
		List<TrExamSystemQuestion> trExamSystemQuestions = new ArrayList<TrExamSystemQuestion>();
		Date time = new Date();
		for (ExamSystemQuestionVOS examSystemQuestionVOS1:examSystemQuestionVOS) {
			trExamSystemQuestion = new TrExamSystemQuestion();
			BeanUtils.copyProperties(examSystemQuestionVOS1, trExamSystemQuestion);
			trExamSystemQuestion.setId(idGenerator.generate());
			trExamSystemQuestion.setExamId(examSystemQuestionVO.getExamId());
			trExamSystemQuestion.setLibraryId(examSystemQuestionVO.getLibraryId());
			trExamSystemQuestion.setState(1);
			trExamSystemQuestion.setCreateById(examSystemQuestionVO.getAccountId());
			trExamSystemQuestion.setCreateByName(examSystemQuestionVO.getAccountName());
			trExamSystemQuestion.setCreateTime(time);
			trExamSystemQuestion.setUpdateById(examSystemQuestionVO.getAccountId());
			trExamSystemQuestion.setUpdateByName(examSystemQuestionVO.getAccountName());
			trExamSystemQuestion.setUpdateTime(time);
			trExamSystemQuestions.add(trExamSystemQuestion);
		}
		boolean result = this.insertBatch(trExamSystemQuestions);
		return result;
	}

	@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean updateTrExamSystemQuestionList(List<TrExamSystemQuestionVO> trExamSystemQuestionVoList,
			Long examId) {
		List<TrExamSystemQuestion> list = new ArrayList<TrExamSystemQuestion>();
		List<TrExamSystemQuestion> updateList = new ArrayList<TrExamSystemQuestion>();
		TrExamSystemQuestion tsq = null;
		Date time = new Date();
		for (TrExamSystemQuestionVO vo : trExamSystemQuestionVoList) {
			tsq = new TrExamSystemQuestion();
			if (vo.getId() == null) { // 新增
				tsq.setId(idGenerator.generate());
				tsq.setExamId(examId);
				tsq.setLibraryId(vo.getLibraryId());
				tsq.setType(vo.getType());
				tsq.setNum(vo.getNum());
				tsq.setScore(vo.getScore());
				tsq.setState(ExamConstant.FIRST);
				tsq.setCreateById(vo.getAccountId());
				tsq.setCreateByName(vo.getAccountName());
				tsq.setCreateTime(time);
				tsq.setUpdateById(vo.getAccountId());
				tsq.setUpdateByName(vo.getAccountName());
				tsq.setUpdateTime(time);
				list.add(tsq);
			} else { // 修改
				tsq = this.selectById(vo.getId());
				tsq.setExamId(examId);
				tsq.setLibraryId(vo.getLibraryId());
				tsq.setType(vo.getType());
				tsq.setNum(vo.getNum());
				tsq.setScore(vo.getScore());
				tsq.setState(vo.getState());
				tsq.setUpdateById(vo.getAccountId());
				tsq.setUpdateByName(vo.getAccountName());
				tsq.setUpdateTime(time);
				updateList.add(tsq);
			}
		}
		if (list.size() > 0) {
			this.insertBatch(list);
		}
		if (updateList.size() > 0) {
			this.updateBatchById(updateList);
		}
		return true;
	}

	/*@Transactional(propagation = Propagation.SUPPORTS, readOnly = true)
	public boolean copyTrExamSystemQuestion(Long oldId, Long examId) {
		List<TrExamSystemQuestion> list = new ArrayList<TrExamSystemQuestion>();
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("state", ExamConstant.FIRST);
		map.put("exam_id", oldId);
		List<TrExamSystemQuestion> selectByMap = this.selectByMap(map);
		TrExamSystemQuestion tq = null;
		for (TrExamSystemQuestion tsq : selectByMap) {
			tq = new TrExamSystemQuestion();
			BeanUtils.copyProperties(tsq, tq);
			tq.setId(idGenerator.generate());
			tq.setExamId(examId);
			setInsertCloumn(tq, true);
			list.add(tq);
		}
		if (list.size() > 0) {
			this.insertBatch(list);
		}
		return true;
	}*/
	
	@Override
	public boolean insertBatchs(List<TrExamSystemQuestion> trExamSystemQuestions) {
		return this.insertBatch(trExamSystemQuestions);
	}

	@Override
	public List<QuestionPreview> selectExamSystemQuestion(Long examId) {
		List<Long> libraryIds = trExamSystemQuestionMapper.selectLibraryIdByExamId(examId);
		List<QuestionPreview> questionPreviews = new ArrayList<QuestionPreview>();
		QuestionPreview questionPreview;
		for (Long libraryId:libraryIds) {
			questionPreview = new QuestionPreview();
			QuestionLibrary questionLibrary = questionLibraryMapper.selectById(libraryId);
			questionPreview.setName(questionLibrary.getName());
			List<ShowExamQuestionVO> showExamQuestionVO = trExamSystemQuestionMapper.selectSystemQuestionByExamIdAndLibraryId(examId,libraryId);
			questionPreview.setShowExamQuestionVO(showExamQuestionVO);
			questionPreviews.add(questionPreview);
		}
		return questionPreviews;
	}

}