package com.yizhi.exam.application.vo;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "PaperInspectionVo", description = "")
@Data
public class PaperInspectionVo {
	
	@ApiModelProperty(value = "阅卷主键")
	private Long readOverId;
	
	@ApiModelProperty(value = "答卷ID，主键")
	private Long id;
	
	@ApiModelProperty(value = "答案题目_ID，外键")
	private Long answerQuestionId;
	
	@ApiModelProperty(value = "学员_ID")
	private Long accountId;
	
	@ApiModelProperty(value = "学员_用户名")
	private String accountName;
	
	@ApiModelProperty(value = "学员_姓名")
	private String name;
	
	@ApiModelProperty(value = "考试主键_ID，外键")
	private Long examId;

	@ApiModelProperty(value = "题目主键_ID，外键")
	private Long subjectId;
	
	@ApiModelProperty(value = "成绩总分数")
	private BigDecimal sumScore;
	
	@ApiModelProperty(value = "考试总分数")
	private BigDecimal score;
	
	@ApiModelProperty(value = "客观题分数，考试中单选题，多选题，判断题，不定项选择题的总分")
	private BigDecimal objectiveScore;

	@ApiModelProperty(value = "主观题分数，问答题总分")
	private BigDecimal subjectiveScore;
	
	@ApiModelProperty(value = "状态，0待阅卷 1已阅卷，2重新阅卷 默认0")
	private Integer state;
	
	@ApiModelProperty(value = "主观试题")
	private  List<ExamQuestionSubjectVo> listExam;
	
	@ApiModelProperty(value = "阅卷人")
	private String readOveUserId;

	@ApiModelProperty(value = "阅卷人姓名")
	private String readOveUserName;
	
	@ApiModelProperty(value = "首次阅卷时间，只记录第一次阅卷的时间")
	private Date firstReadOveTime;

	@ApiModelProperty(value = "阅卷时间，多次阅卷更新此时间")
	private Date readOveTime;
	
	@ApiModelProperty(value = "阅卷合计次数")
	private Integer sumNum;
	
	@ApiModelProperty(value = "企业_ID")
	private Long companyId;

	@ApiModelProperty(value = "部门_ID")
	private Long orgId;

	@ApiModelProperty(value = "站点_ID")
	private Long siteId;
	
}
