package com.yizhi.exam.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 客观题答案选项（单选题，多选题，判断题）
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@ApiModel(value = "TrExamAnswerQuestionRes", description = "客观题答案选项（单选题，多选题，判断题）")
@Data

public class TrExamAnswerQuestionRes {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "答案ID，主键")
	private Long id;

	@ApiModelProperty(value = "答卷ID，主键")
	
	private Long answerId;

	@ApiModelProperty(value = "答案题目_ID，外键")
	
	private Long answerQuestionId;

	@ApiModelProperty(value = "题目选项_ID，外键")
	
	private Long optionId;

	@ApiModelProperty(value = "用户答案，存放题目ID, 0 未选择， 1 答案")
	private Integer answer;

	@ApiModelProperty(value = "正确答案, 0 未选择， 1 答案")
	
	private Integer rightAnswer;

	@ApiModelProperty(value = "创建时间")
	
	private Date createTime;

	@ApiModelProperty(value = "创建人ID")
	
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	
	private Date updateTime;

	@ApiModelProperty(value = "修改人ID")
	
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	
	private String updateByName;
	
	@ApiModelProperty(value = "排序")
	
	private Integer sort;

}
