package com.yizhi.exam.application.vo.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * <p>
 * 题目选项,题型是：1单选题、2多选题、3判断题有效
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@ApiModel(value = "TrQuestionSubjectOption", description = "题目选项,题型是：1单选题、2多选题、3判断题有效")
@Data

public class TrQuestionSubjectOption  {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "题目主键_ID，外键")
	
	private Long subjectId;

	@ApiModelProperty(value = "选项内容，存放文字、图片、音频、视频")
	private String content;

	@ApiModelProperty(value = "选项附件路径，图片、音频、视频存放路径")
	
	private String optionAppendixUrl;

	@ApiModelProperty(value = "正确答案，0否 1是，默认0")
	
	private Integer isAnswer;

	@ApiModelProperty(value = "排序")
	private Integer sort;

	@ApiModelProperty(value = "状态，0删除 1有效，默认1")
	private Integer state;

	@ApiModelProperty(value = "创建时间")
	
	private Date createTime;

	@ApiModelProperty(value = "创建人ID")
	
	private Long createById;

	@ApiModelProperty(value = "创建人姓名")
	
	private String createByName;

	@ApiModelProperty(value = "修改时间")
	
	private Date updateTime;

	@ApiModelProperty(value = "修改人ID")
	
	private Long updateById;

	@ApiModelProperty(value = "修改人姓名")
	
	private String updateByName;

}
