package com.yizhi.application.controller;

import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.service.*;
import com.yizhi.application.service.impl.TrExamQuestionServiceImpl;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.core.application.vo.DroolsVo;
import com.yizhi.exam.application.vo.*;
import com.yizhi.exam.application.vo.domain.Exam;
import com.yizhi.exam.application.vo.exam.ExamQuestionListVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * <p>
 * 考试 前端控制器 管理端
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@RestController
@RequestMapping("/manage/exam")
public class ExamManageController {

	private static final Logger LOG = LoggerFactory.getLogger(ExamManageController.class);

	@Autowired
	private IExamService examService;
	@Autowired
	private TrExamQuestionServiceImpl trExamQuestionService;
	@Autowired
	private ITrExamQuestionSortService trExamQuestionSortService;
	@Autowired
	private ITrExamSystemQuestionService trExamSystemQuestionService;
	@Autowired
	private ITrQuestionLibrarySubjectService trQuestionLibrarySubjectService;
	@Autowired
	private ITrExamAuthorizeService iTrExamAuthorizeService;

	@PostMapping(value={"/info/insert", "/info/update"})
	public Long insertOrUpdateBaseInfo(@RequestBody BaseInfoVO vo){
		Long examId = null;
		try{
			examId = examService.insertOrUpdateBaseInfo(vo);
			return examId;
		}catch (Exception e) {
			LOG.error("创建考试-基本信息保存编辑:" + e);
			return examId;
		}
	}

	@PostMapping("/question/select/insert")
	public Long updateExamQuestion(@RequestBody AddQuestionVO vo){
		Long examId = null;
		try{
			examId = examService.updateExamQuestion(vo);
			return examId;
		}catch (Exception e) {
			LOG.error("创建考试-添加试题保存:" + e);
			return examId;
		}
	}

	@PostMapping("/system/list")
	public List<TrExamSystemQuestionVO> listTrExamSystemQuestion(
			 @RequestParam("examId") Long examId){
		List<TrExamSystemQuestionVO> list = null;
		try{
			list = trExamSystemQuestionService.listTrExamSystemQuestion(examId);
			return list;
		}catch (Exception e) {
			LOG.error("创建考试:" + e);
			return list;
		}
	}

	@PostMapping("/question/sort/list")
	public List<TrExamQuestionSortVO> listTrExamQuestionSort(
			@RequestParam("examId") Long examId){
		List<TrExamQuestionSortVO> list = null;
		try{
			list = trExamQuestionSortService.listTrExamQuestionSort(examId);
			return list;
		}catch (Exception e) {
			LOG.error("创建考试-添加试题-题干排序-题型排序列表:" + e);
			return list;
		}
	}

	@PostMapping("/strategy/list")
	public ExamStrategyVO listExamStrategy(
			@RequestParam("examId") Long examId){
		ExamStrategyVO examStrategyVo = null;
		try{
			examStrategyVo = examService.listExamStrategy(examId);
			return examStrategyVo;
		}catch (Exception e) {
			LOG.error("创建考试-考试策略 列表:" + e);
			return examStrategyVo;
		}
	}

	@PostMapping(value={"/strategy/insert", "/preview"})
	public Long updateExamStrategy(@RequestBody ExamStrategyVO vo){
		Long examId = null;
		try{
			examId = examService.updateOrPreviewExamStrategy(vo);
			return examId;
		}catch (Exception e) {
			LOG.error("创建考试-考试策略 保存:" + e);
			return examId;
		}
	}

	@PostMapping("/copy")
	public boolean copyExamRelated(
			@RequestBody com.yizhi.exam.application.vo.domain.Exam exam){
		boolean result = false;
		try{
			result = examService.copyExamAndView(exam);
			return result;
		}catch (Exception e) {
			LOG.error("创建考试:" + e);
			return result;
		}
	}


	@PostMapping(value={"/release"})
	public Long releaseExamRelated(@RequestBody ExamStrategyVO vo){
		Long examId = null;
		try{
			examId = examService.releaseExamRelated(vo);
			return examId;
		}catch (Exception e) {
			LOG.error("创建考试-发布考试:" + e);
			return examId;
		}
	}

	@GetMapping("/question/select/list")
	public Map<String,Object> listExamQuestion(
			@RequestBody ContextAndPageSizeVO contextAndPageSizeVO){
		Page<SelectQuestionVO> list = null;
		try{
			Map<String, Object> map = new HashMap<String, Object>();
			RequestContext context = ContextHolder.get();
			if (!context.isAdmin()) {
				contextAndPageSizeVO.setOrgIds(context.getManagerIds());
			}
			List<LibrarySubjectVO> librarySubjectVOS = trQuestionLibrarySubjectService.selectLibrarySubjectList(contextAndPageSizeVO);
			Integer count = trQuestionLibrarySubjectService.selectLibrarySubjectCount(contextAndPageSizeVO);
			map.put("list",librarySubjectVOS);
			map.put("pageTotal",count);
			return map;
		}catch (Exception e) {
			e.printStackTrace();
			LOG.error("考试试题列表:{}", e);
			return null;
		}
	}

	@PostMapping("/question/insertall")
	public boolean insertExamQuestion(@RequestBody ExamQuestionListVO examQuestionListVO){
		return trExamQuestionService.insertQuestion(examQuestionListVO);
	}

	/**
	 * 查询范围列表
	 * */
	@GetMapping("/authorize/list")
	public List<TrExamAuthorizeVO> selectAuthorizeVO(@RequestParam("examId")Long examId){
		return iTrExamAuthorizeService.listTrExamAuthorize(examId);
	}

	/**
	 * 新增考试人员范围
	 * */
	@PostMapping("/insert/authorize/list")
	public boolean insertAllAuthorize(@RequestBody List<TrExamAuthorizeVO> trExamAuthorizeVOS,@RequestParam Long accountId,@RequestParam String accountName,@RequestParam("siteId") Long siteId){
		if(CollectionUtils.isEmpty(trExamAuthorizeVOS)){
			return false;
		}
		return iTrExamAuthorizeService.insertAllAuthorize(trExamAuthorizeVOS,accountId,accountName,siteId);
	}

	@PostMapping("/statistical/examByUser")
	public Page<StatisticalByUserVO> examByUser(@RequestBody ExamCountByUserVO vo){
		return examService.examByUser(vo);
	}

	@PostMapping("/statistical/selectExamByName")
	public List<Exam> selectExamByName(@RequestBody ExamCountExportParamVO vo){
		return examService.selectExamByName(vo);
	}

	@PostMapping("/statistical/examAnswerByExamId")
	public List<StatisticalByUserVO> examAnswerByExamId(@RequestBody ExamCountByUserVO ecvo){
		return examService.examAnswerByExamId(ecvo);
	}

	@PostMapping("/getMinAndMaxPointSum")
	Map<String, Integer> getMinAndMaxPointSum(@RequestBody List<Long> examIds){
		return examService.getMinAndMaxPointSum(examIds);
	}
	@GetMapping("/getPageByDrools")
	Page<DroolsVo> getPageByDrools(@RequestParam("field") String field,
								   @RequestParam(value = "value", required = false) String value,
								   @RequestParam("pageNo") Integer pageNo,
								   @RequestParam("pageSize") Integer pageSize) {
		Page<DroolsVo> page = new Page<>(pageNo, pageSize);
		return examService.getPageByDrools(field, value, page);
	}
}

