package com.yizhi.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 考试阅卷
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */

@Data
@TableName("tr_exam_online_read_over")
public class TrExamOnlineReadOver extends Model<TrExamOnlineReadOver> {

	private static final long serialVersionUID = 1L;

	
	@TableId("read_over_id")
	private Long readOverId;

	
	@TableField("exam_id")
	private Long examId;

	
	@TableField("exam_answer_id")
	private Long examAnswerId;

	
	@TableField("answer_question_id")
	private Long answerQuestionId;

	
	@TableField("account_id")
	private Long accountId;

	
	@TableField("read_ove_user_id")
	private String readOveUserId;

	
	@TableField("read_ove_user_name")
	private String readOveUserName;

	
	@TableField("first_read_ove_time")
	private Date firstReadOveTime;

	
	@TableField("read_ove_time")
	private Date readOveTime;

	
	@TableField("sum_num")
	private Integer sumNum;

	
	@TableField("sum_score")
	private BigDecimal sumScore;

	
	@TableField("objective_score")
	private BigDecimal objectiveScore;

	
	@TableField("subjective_score")
	private BigDecimal subjectiveScore;

	
	private Integer state;

	
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

	
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

	
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

	
	@TableField("company_id")
	private Long companyId;

	
	@TableField("org_id")
	private Long orgId;

	
	@TableField("site_id")
	private Long siteId;

	
	@TableField(value = "read_type", fill = FieldFill.INSERT)
	private Integer readType;
	
	@Override
	protected Serializable pkVal() {
		return this.readOverId;
	}
}
