package com.yizhi.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 考试分数通用评价
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */

@Data
@TableName("tr_exam_score_evaluate")
public class TrExamScoreEvaluate extends Model<TrExamScoreEvaluate> {

	private static final long serialVersionUID = 1L;

	
	private Long id;

	
	@TableField("exam_id")
	private Long examId;

	
	@TableField("min_score")
	private Integer minScore;

	
	@TableField("max_score")
	private Integer maxScore;

	
	private String description;

	
	private Integer state;

	
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

	
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

	
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}