package com.yizhi.application.domain;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableField;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.FieldFill;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 题目选项,题型是：1单选题、2多选题、3判断题有效
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */

@Data
@TableName("tr_question_subject_option")
public class TrQuestionSubjectOption extends Model<TrQuestionSubjectOption> {

	private static final long serialVersionUID = 1L;

	
	private Long id;

	
	@TableField("subject_id")
	private Long subjectId;

	
	private String content;

	
	@TableField("option_appendix_url")
	private String optionAppendixUrl;

	
	@TableField("is_answer")
	private Integer isAnswer;

	
	private Integer sort;

	
	private Integer state;

	
	@TableField(value = "create_time", fill = FieldFill.INSERT)
	private Date createTime;

	
	@TableField(value = "create_by_id", fill = FieldFill.INSERT)
	private Long createById;

	
	@TableField(value = "create_by_name", fill = FieldFill.INSERT)
	private String createByName;

	
	@TableField(value = "update_time", fill = FieldFill.INSERT)
	private Date updateTime;

	
	@TableField(value = "update_by_id", fill = FieldFill.INSERT)
	private Long updateById;

	
	@TableField(value = "update_by_name", fill = FieldFill.INSERT)
	private String updateByName;

	@Override
	protected Serializable pkVal() {
		return this.id;
	}
}
