package com.yizhi.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.Exam;
import com.yizhi.application.domain.TrExamPoint;
import com.yizhi.exam.application.vo.*;
import com.yizhi.exam.application.vo.exam.ExamDetailsVO;

import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 考试 Mapper 接口
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface ExamMapper extends BaseMapper<Exam> {

    List<Exam> idList(ContextAndPageSizeVO contextAndPageSizeVO);

    @Select({"<script>",
            " SELECT ex.*"
                    + " FROM exam ex"
                    + " WHERE ex.state!=0"
                    + " <when test='name!=null'>", "and ex.name like  CONCAT('%',#{name},'%' )", "</when>"
            + " GROUP BY ex.id ",
            " ORDER BY ex.create_time asc ", "</script>"})
    List<Exam> selectExamList(@Param("companyId") Long companyId, @Param("name") String name);

    @Select({"<script>", "select count(1) from (",
            "SELECT e.* FROM exam e WHERE e.id IN(SELECT DISTINCT exam_id FROM tr_exam_question_sort tr WHERE tr.type IN (1,2,3)) AND e.state IN (1,2,3) and e.site_id=#{siteId}",
            "<when test='name!=null'>", "and e.name like  CONCAT('%',#{name},'%' )", "</when>) a", "</script>"})
    Integer getMarkingListNum(@Param("name") String name, @Param("siteId") Long siteId);

    int updateState(@Param("state") Integer state, @Param("examId") Long examId, @Param("upTime") Date upTime, @Param("downTime") Date downTime);

    @Select("select max(e.exam_no) from exam e")
    String queryMaxExamNo();

    List<ExamQuestionTypeVO> selectTypeById(@Param("examId") Long examId);

    List<MyExamVO> selectMyExamInfo(@Param("start") Integer start, @Param("end") Integer end, @Param("ids") List<Long> ids,
                                    @Param("state") Integer state, @Param("accountId") Long accountId, @Param("siteId") Long siteId);


    @Select("select count(*) from tr_exam_answer where exam_id= #{examId} and account_id = #{accountId}")
    Integer submitCount(@Param("examId") Long examId, @Param("accountId") Long accountId);

    Integer selectTotalInfo(@Param("ids") List<Long> ids, @Param("state") Integer state, @Param("accountId") Long accountId, @Param("siteId") Long siteId);

    List<MyExamVO> selectMyExamnation(@Param("start") Integer start, @Param("end") Integer end, @Param("accountId") Long accountId);

    Integer selectAll(@Param("accountId") Long accountId);

    List<QuestionExamVO> exportAnswer(@Param("examId") Long examId, @Param("companyId") Long companyId, @Param("orgId") Long orgId, @Param("siteId") Long siteId);

    String[] exportOptionAnswers(@Param("answerId") Long answerId);

    String[] exportOptionAnswer(@Param("answerId") Long answerId);

    ExamDetailsVO examDetail(@Param("examId") Long examId, @Param("companyId") Long companyId, @Param("orgId") Long orgId, @Param("siteId") Long siteId);


    @Select("select count(id) from cloud_exam.exam where create_by_id = #{accountId}")
    Integer selectCountByAccountId(@Param("accountId") Long accountId);

    /**
     * 首页搜索考试信息
     *
     * @param page      分页对象
     * @param keyWord   查询关键字
     * @param accountId 员工号
     * @param companyId 企业号
     * @param siteId    站点ID
     * @param orgId     组织
     * @return
     */
    List<Exam> selectExamLikeName(@Param("page") Page<Exam> page, @Param("keyWord") String keyWord,
                                  @Param("accountId") Long accountId, @Param("companyId") Long companyId, @Param("siteId") Long siteId, @Param("orgId") Long orgId);

    /**
     * 获取考试信积分信息
     *
     * @param examId    考试号
     * @param companyId 企业号
     * @param siteId    站点ID
     * @param orgId     组织
     * @return
     */
    List<TrExamPoint> selectExamPointInfo(@Param("examId") Long examId, @Param("companyId") Long companyId,
                                          @Param("siteId") Long siteId, @Param("orgId") Long orgId);

    /**
     * 根据考试名称关键字查询所有考试信息
     */
    List<Exam> selectExamListByName(ContextAndPageSizeVO contextAndPageSizeVO);

   List<ExamDetailsMarkingVO> selectExamListBySta(ContextAndPageSizeVO contextAndPageSizeVO);

    @Select({"<script>",
            " SELECT ex.*"
                    + " FROM exam ex"
                    + " WHERE ex.state>1 and company_id = #{companyId}"
                    + " <when test='name!=null'>", "and ex.name like  CONCAT('%',#{name},'%' )", "</when>"
            , "</script>"})
    List<Exam> selectExamListByNameExport(@Param("name") String name, @Param("companyId") Long companyId);

    /**
     * 根据考试名称关键字查询所有考试信息
     */
    int selectExamListByNameCount(ContextAndPageSizeVO contextAndPageSizeVO);

    @Select("SELECT id FROM exam WHERE visible_range = 1 AND state = 2 AND site_id = #{siteId}")
    List<Long> selectExamIdByVisable(@Param("siteId") Long siteId);

    List<StatisticalByUserVO> examByUser(Page<StatisticalByUserVO> page, ExamCountByUserVO vo);

    List<Exam> selectExamByName(ExamCountExportParamVO vo);

    List<StatisticalByUserVO> examByUser(ExamCountByUserVO ecvo);

    /**
     * 查询我的考试没提交的
     *

     */
    Integer selectMyExamNoSubmit(@Param("accountId") Long accountId);

    /**
     * 我的考试搜索
     *
     * @param page
     * @param ids
     * @param accountId
     * @return
     */
    List<MyExamVO> searchMyExamInfo(@Param("page") Page<MyExamVO> page, @Param("ids") List<Long> ids,
                                    @Param("accountId") Long accountId, @Param("keyWord") String keyWord);

    int deleteUnExamPoint(@Param("accountId") Long accountId, @Param("accountName") String accountName,
                          @Param("examId") Long examId, @Param("ids") List<TrExamPoint> ids);

    @Update("update exam set qualified_score = null where id = #{examId}")
    Integer updataQualifiedScore(@Param("examId") Long examId);

    Long selectRangeExam(@Param("examId") Long examId, @Param("orgIds") List<Long> orgIds, @Param("siteId") Long siteId);

    List<Map<String, Object>> getPoolExamList(@Param("name") String name, @Param("ids") List<Long> ids, @Param("companyId") Long companyId,
                                              @Param("siteId") Long siteId, @Param("orgIds") List<Long> orgIds, Page<Map<String, Object>> page);

    List<MyExamVO> myPcExam(@Param("state") Integer state,@Param("accountId") Long accountId,@Param("examIds") List<Long> examIds,@Param("siteId") Long siteId, Page<MyExamVO> page);

    Integer myPcExamCount(@Param("state") int state,@Param("accountId") Long accountId,@Param("examIds") List<Long> examIds,@Param("siteId") Long siteId);

    /**
     * 胡涛需要,获得所有考试最小积分和最大积分之和
     * @param examIds
     * @return
     */
    Map<String, Integer> getMinAndMaxPointSum(@Param("examIds") List<Long> examIds);

    /**
     * 胡涛需要,查找七内结束的考试
     * @return
     * @param companyId
     * @param siteId
     * @param accountId
     */
    List<Exam> getExpireList(@Param("companyId") Long companyId, @Param("siteId") Long siteId,@Param("accountId") Long accountId);

    List<Long> getIdsByDate(@Param("currentDate") Date currentDate, @Param("siteId") Long siteId);

    List<Exam> getPageToCalendar(@Param("finishIds") List<Long> finishIds,
                                            @Param("ids") List<Long> ids,
                                            @Param("currentDate") Date currentDate,
                                            @Param("siteId") Long siteId,
                                            Page page);

    Integer getPageToCalendarNum(@Param("finishIds") List<Long> finishIds,
                                 @Param("ids") List<Long> ids,
                                 @Param("currentDate") Date currentDate,
                                 @Param("siteId") Long siteId);

    /**
     * 获取多个考试每个考试的最高分
     * @param examIds
     * @param accountId
     * @return
     */
    @MapKey("examId")
    Map<Long, Map<String, Object>> getMaxScores(@Param("examIds") List<Long> examIds,@Param("accountId") Long accountId);

    /**
     * 删除考试
     * @param list
     */
    void deleteExams(@Param("list") List<Long> list);

    /**
     * 工作台 考试合格率统计相关
     * @param contextAndPageSizeVO
     * @return
     */
    int selectCommitTotalCnt(ContextAndPageSizeVO contextAndPageSizeVO);
    int selectCommitPassCnt(ContextAndPageSizeVO contextAndPageSizeVO);
    int selectCommitOncePassCnt(ContextAndPageSizeVO contextAndPageSizeVO);
}
