package com.yizhi.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.plugins.Page;
import com.yizhi.application.domain.StatisticsExamMetadata;
import com.yizhi.exam.application.vo.domain.Exam;
import com.yizhi.exam.application.vo.domain.StatisticsExamLearnMetadata;
import com.yizhi.exam.application.vo.domain.TrExamAuthorize;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

//import com.yizhi.application.exam.domain.StatisticsExamRecorde;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author dingxiaowei123
 * @since 2018-08-01
 */
public interface StatisticsExamMetadataMapper extends BaseMapper<StatisticsExamMetadata> {
	
	/**
	 * 查询统计的考试信息，分页查询
	 * @param paramMap
	 * @return
	 */
	List<Long> selectAccountLearnList(@Param("paramMap") Map<String, Object> paramMap, @Param("page") Page<Long> page);
	
    List<Exam> getAllExams(@Param("startDate")String startDate, @Param("endDate")String endDate);

    List<TrExamAuthorize> getExamRangeByExamId(Long examId);

    List<Map<String, Object>> getAllTrExamAnser(
                                               @Param("examId") Long examId,
                                               @Param("accountIds") List<Long> accountIds,
                                               @Param("startDate") String startDate,
                                               @Param("endDate") String endDate);
    
    Date selectMaxDate();
	
	Date selectRecordMinTime();

	Integer deleteRecordeByDate(@Param("currentDate")String currentDate);
	
	/**
	 * 批量插入考试答卷记录
	 * @param examId 考试ID
	 * @param curDate 考试日期
	 * @return 
	 */
	int insertAccountLearn(@Param("examId")Long examId, @Param("curDate")String curDate);
	
	/**
	 * 获取考试答卷
	 * @param examId 课程ID
	 * @param curDate 考试日期
	 * @return 返回考试的学生ID集合
	 */
	@MapKey("account_id")
	List<StatisticsExamLearnMetadata> selectAccountLearn(@Param("examId")Long examId, @Param("curDate")String curDate);
	
	/**
	 * 查找该考试有没有人参加了
	 * @param examId
	 * @return
	 */
	Integer selectEmptyExamLearnCount(@Param("examId")Long examId);
	
	/**
	 * 查找学员有没有考试
	 * @param ExamId
	 * @param accountId
	 * @return
	 */
	Integer selectEmptyExamAccountLearnCount(@Param("examId") Long examId, @Param("accountId") Long accountId);
	
	/**
	 * 删除没有学习记录的学员信息
	 */
	void deleteEmptyAccountLearn();
	
	/**
	 * 查找学员有没有学了该课程
	 * @param ExamId
	 * @param accountId
	 * @return
	 */
	@MapKey("accountId")
	Map<Long, Long> selectAccountLearnByExamId(@Param("examId") Long examId);
	
	/**
	 * 按部门纬度统计数据量会很大,影响效率.对其进行拆分，按部门统计从此表中查询
	 */
	void insertStatisticsExamToGroupFind();
	
	void deleteStatisticsExamToGroupFind();
	
	/**
	 * 课程信息直接从statistics_exam_metadata表中查询效率很慢，对其进行拆分.按课程和用户统计的查询条件从此获取
	 */
	void insertStatisticsExamToAccountGroupFind();
	
	void deleteStatisticsExamToAccountGroupFind();

	List<StatisticsExamLearnMetadata> getRecords(@Param("examId") Long examId, @Param("startDate") String startDate,@Param("endDate") String endDate);

    List<Long> getAllExamSiteIds();
}