package com.yizhi.application.mapper;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.yizhi.application.domain.TrExamQuestion;
import com.yizhi.exam.application.vo.ExamQuestionLibraryVO;
import com.yizhi.exam.application.vo.ShowExamQuestionVO;
import com.yizhi.exam.application.vo.exam.SumQuestionVO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.RowBounds;

import java.util.List;

/**
 * <p>
 * 考试题目 Mapper 接口
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface TrExamQuestionMapper extends BaseMapper<TrExamQuestion> {
	/**
	 * 试题预览系统出题
	 * @return
	 */
	@Select("SELECT b.type AS TYPE,COUNT(a.id) AS numSum,IFNULL(SUM(a.score),0) AS score FROM tr_exam_question a\n" +
			"            LEFT JOIN tr_question_library_subject b ON b.id = a.subject_id\n" +
			"            WHERE a.state=1 and exam_id = #{examId} GROUP BY b.type")
	List<ShowExamQuestionVO> examPreview(@Param("examId") Long examId);
	
	/**
	 * 试题预览必填题
	 * @return
	 */
	List examPreviews(Long examTitleId);

	/**
	 * 获取考试试题总数和总分数
	 * */
	@Select("select count(id) as num,sum(score) as score from tr_exam_question where exam_id = #{examId} AND state=1")
	SumQuestionVO selectCountAndScore(@Param("examId") Long examId);

	@Select("SELECT COUNT(id) FROM tr_exam_question")
	Integer selectCount();

	@Select("SELECT a.id,a.score,a.state,b.stem,b.type,b.library_id AS libraryId,a.sort FROM tr_exam_question a\n" +
			"\t\tLEFT JOIN tr_question_library_subject b ON a.subject_id = b.id\n" +
			"\t\tWHERE exam_id = #{examId} and a.state = 1 ORDER BY a.sort")
	List<ExamQuestionLibraryVO> selectExamQuestionListById(@Param("examId") Long examId, RowBounds rowBounds);

	Integer updateAllById(@Param("list") List<Long> list);

	/**
	 * 获取此考试中是否有试题
	 * */
	@Select("select count(id) from tr_exam_question where exam_id = #{examId}")
	Integer selectQuestionCountByExamId(@Param("examId") Long examId);

	@Delete("delete from tr_exam_question where exam_id = #{examId}")
	Integer deleteByExamId(@Param("examId") Long examId);

	@Update("update tr_exam_question set state = 0 where exam_id = #{examId}")
	Integer updateByExamId(@Param("examId") Long examId);

	@Select("SELECT subject.type FROM cloud_exam.tr_exam_question as examQuestion\n" +
			"inner join cloud_exam.tr_question_library_subject as subject on subject.id = examQuestion.subject_id\n" +
			" where examQuestion.exam_id = #{examId}")
	List<Integer> selectType(@Param("examId") Long examId);
}