package com.yizhi.application.service;

import com.baomidou.mybatisplus.service.IService;
import com.yizhi.application.domain.TrExamSystemQuestion;
import com.yizhi.exam.application.vo.ExamSystemQuestionVO;
import com.yizhi.exam.application.vo.QuestionPreview;
import com.yizhi.exam.application.vo.TrExamSystemQuestionVO;

import java.util.List;

/**
 * <p>
 * 系统出题规则 服务类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
public interface ITrExamSystemQuestionService extends IService<TrExamSystemQuestion> {

	/**
	 * 更新 出题规则
	 * @param trExamSystemQuestionVoList
	 * @param examId
	 * @return
	 */
	boolean updateTrExamSystemQuestionList(List<TrExamSystemQuestionVO> trExamSystemQuestionVoList, Long examId);

	/**
	 * 复制出题规则
	 * @param oldExamId
	 * @param id
	 * @return
	 */
	/*boolean copyTrExamSystemQuestion(Long oldExamId, Long id);*/

	/**
	 * 系统出题规则  列表
	 * @param id
	 * @return
	 */
	List<TrExamSystemQuestionVO> listTrExamSystemQuestion(Long examId);

	/**
	 * 创建系统出题规则
	 * */
	boolean insertAll(ExamSystemQuestionVO examSystemQuestionVO);
	
	/**
	 * 创建所有系统出题规则
	 * */
	boolean insertBatchs(List<TrExamSystemQuestion> trExamSystemQuestions);

	/**
	 * 查询所有出题规则按照题库ID分组
	 * */
	List<QuestionPreview> selectExamSystemQuestion(Long examId);
}