package com.yizhi.application.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.yizhi.application.domain.TrExamAnswerQuestionResMa;
import com.yizhi.core.application.context.ContextHolder;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.application.mapper.TrExamAnswerQuestionResMaMapper;
import com.yizhi.application.service.ITrExamAnswerQuestionResMaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * <p>
 * 主观题答案选项 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class TrExamAnswerQuestionResMaServiceImpl
		extends ServiceImpl<TrExamAnswerQuestionResMaMapper, TrExamAnswerQuestionResMa>
		implements ITrExamAnswerQuestionResMaService {

	@Autowired
	TrExamAnswerQuestionResMaMapper trExamAnswerQuestionResMaMapper;
	

	@Override
	public void setInsertCloumn(TrExamAnswerQuestionResMa ma) {
		Long accountId = 9999L;
		String accountName = "bob";
		RequestContext requestContext = ContextHolder.get();
		if (null != requestContext) {
			if (null != requestContext.getAccountId()) {
				accountId = requestContext.getAccountId();
			}
			if (null != requestContext.getAccountName()) {
				accountName = requestContext.getAccountName();
			}
		}
		
		ma.setCreateById(accountId);
		ma.setCreateByName(accountName);
		ma.setCreateTime(new Date());
		ma.setUpdateById(accountId);
		ma.setUpdateByName(accountName);
		ma.setUpdateTime(new Date());
	}

	@Override
	public String selectAnswer(Long id,Long answerId) {
		return trExamAnswerQuestionResMaMapper.selectAnswer(id,answerId);
	}

	@Override
	public TrExamAnswerQuestionResMa selectAnswerQuestionOptionMainByAnswerIdAndQuestionId(Long answerId,
			Long questionId) {
		return trExamAnswerQuestionResMaMapper.selectAnswerQuestionOptionByAnswerIdAndQuestionId(answerId, questionId);
	}

}
