package com.yizhi.application.service.impl;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.yizhi.application.domain.TrQuestionSubjectOption;
import com.yizhi.application.mapper.TrQuestionSubjectOptionMapper;
import com.yizhi.application.service.ITrQuestionSubjectOptionService;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 题目选项,题型是：1单选题、2多选题、3判断题有效 服务实现类
 * </p>
 *
 * @author yizhi123
 * @since 2018-03-13
 */
@Service
public class TrQuestionSubjectOptionServiceImpl extends
        ServiceImpl<TrQuestionSubjectOptionMapper, TrQuestionSubjectOption> implements ITrQuestionSubjectOptionService {
    @Autowired
    private TrQuestionSubjectOptionMapper trQuestionSubjectOptionMapper;

    @Override
    public List<TrQuestionSubjectOption> queryTrQuestionSubjectOptionList(Long subjectId) {
        TrQuestionSubjectOption trQuestionSubjectOption = new TrQuestionSubjectOption();
        if (subjectId != 0 && null != subjectId) {

            trQuestionSubjectOption.setSubjectId(subjectId);

            EntityWrapper<TrQuestionSubjectOption> entityWrapper = new EntityWrapper<>(trQuestionSubjectOption);
            entityWrapper.orderBy("sort", true);

            List<TrQuestionSubjectOption> list = trQuestionSubjectOptionMapper.selectList(entityWrapper);

            if (list.size() > 0 && null != list) {

                return list;

            }
            return null;
        }

        return null;

    }
}

