package com.yizhi.application.util;

import com.yizhi.core.application.publish.PublicSendMessageClient;
import com.yizhi.exam.application.vo.MessageTaskRemindVo;
import com.yizhi.exam.application.vo.domain.Exam;
import com.yizhi.core.application.context.RequestContext;
import com.yizhi.exam.application.enums.EvenType;
import com.yizhi.message.application.enums.RelationType;
import com.yizhi.core.application.event.EventWrapper;
import com.yizhi.core.application.vo.MessageRemindVo;
import com.yizhi.core.application.vo.TaskVo;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Component
public class ExamEvenSendMessage {

    @Autowired
    private PublicSendMessageClient publicSendMessageClient;
    private Logger logger = LoggerFactory.getLogger(ExamEvenSendMessage.class);

    /**
     * 触发事件,根据可见范围发消息
     *
     * @param exam      业务参数对象
     * @param accountId 用户id为空
     */
    public void evenSendMessage(Exam exam, Long accountId, EvenType evenType, Double score) {

        if (exam != null) {
            TaskVo taskVo = new TaskVo();
            taskVo.setTaskName(exam.getName());
            taskVo.setTaskStratTime(exam.getStartTime());
            taskVo.setTaskEndTime(exam.getEndTime());
            taskVo.setTaskScore(score);

            MessageRemindVo vo = new MessageRemindVo();
            vo.setTaskVo(taskVo);
            vo.setVisibleRange(exam.getVisibleRange());
            vo.setMessageId(evenType.getKey());
            vo.setMessageType(3);
            vo.setRelationId(exam.getId());
            vo.setRelationType(RelationType.KS.getKey());
            vo.setSendType(1);
            //定时任务默认五分钟执行一次   这里默认暂时不延迟时间
            vo.setSendTime(DateUtils.addMinutes(new Date(), 0));
            if (accountId != null) {
                vo.setAccountId(accountId);
            }
            RequestContext requestContext = new RequestContext();
            requestContext.setCompanyId(exam.getCompanyId());
            requestContext.setSiteId(exam.getSiteId());
            requestContext.setAccountId(exam.getCreateById());
            requestContext.setAccountName(exam.getCreateByName());
            vo.setRequestContext(requestContext);
            logger.info("站点ID:"+requestContext.getSiteId());
            try {
                //临时取消触发功能
//                cloudEventPublisher.publish(Constans.MESSAGE_QUEUE, new EventWrapper<MessageRemindVo>(null, vo));
//                logger.error("发送消息成功=====================");
            } catch (Exception e) {
                e.printStackTrace();
                logger.error("发送消息失败=====================", e);
            }
        }
    }

    /**
     * 系统模板,发消息
     *
     * @param exam 业务参数对象
     */
    public void systemSendMessage(Exam exam, com.yizhi.exam.application.vo.MessageRemindVo remindVo, RequestContext context) {
        MessageRemindVo vo = new MessageRemindVo();

        //共用参数
        vo.setMessageType(2);
        vo.setRelationId(exam.getId());
        vo.setRelationType(RelationType.KS.getKey());
        vo.setTaskStatus(exam.getState().equals(2) ? 1 : 0);
        if (context == null) {
            context = new RequestContext();
            context.setCompanyId(exam.getCompanyId());
            context.setSiteId(exam.getSiteId());
            context.setAccountName(exam.getCreateByName());
            context.setAccountId(exam.getCreateById());
        }
        vo.setRequestContext(context);
        if (vo.getMessageType() == null || vo.getRelationId() == null || vo.getRelationType() == null) {
            logger.info("messageType:"+remindVo.getMessageType()+"||"+"RelationId:"+remindVo.getRelationId()
                    +"||"+"RelationType:"+remindVo.getRelationType());
            logger.info("相关参数缺失！！");
            return;
        }

        if (remindVo.getHasDeleted()) {
            vo.setHasDeleted(remindVo.getHasDeleted());
            publicSendMessageClient.processBizEvent(vo);
        } else {
            //修改考试的状业务态
            if (remindVo.getTaskStatusUpdate()) {
                //1 为消息业务可发送状态  0 则不行
                vo.setTaskStatusUpdate(remindVo.getTaskStatusUpdate());
                publicSendMessageClient.processBizEvent(vo);
                logger.info("发送修改业务状态消息成功=====================");
                return;
            }
            if (exam != null) {
                if (!CollectionUtils.isEmpty(remindVo.getMessageTaskRemindVos())) {
                    TaskVo taskVo = new TaskVo();
                    taskVo.setTaskName(exam.getName());
                    taskVo.setTaskStratTime(exam.getStartTime());
                    taskVo.setTaskEndTime(exam.getEndTime());
                    vo.setMessageId(remindVo.getMessageId());
                    vo.setIsChangge(remindVo.getIsChangge());
                    List<MessageTaskRemindVo> m=  remindVo.getMessageTaskRemindVos();
                    List<com.yizhi.core.application.vo.MessageTaskRemindVo> m2=new ArrayList<>();
                    for (MessageTaskRemindVo m1:m
                    ) {
                        com.yizhi.core.application.vo.MessageTaskRemindVo mx=new com.yizhi.core.application.vo.MessageTaskRemindVo();
                        BeanUtils.copyProperties(m1,mx);
                        m2.add(mx);
                    }
                    vo.setMessageTaskRemindVos(m2);
                    vo.setSendType(remindVo.getSendType());
                    vo.setVisibleRange(exam.getVisibleRange());
                    vo.setTaskVo(taskVo);

                    if (vo.getMessageId() == null || vo.getSendType() == null || vo.getVisibleRange() == null) {
                        logger.info("messageID:"+remindVo.getMessageId()+"||"+"sendType:"+remindVo.getSendType()
                                +"||"+"VisibleRange:"+remindVo.getVisibleRange());
                        logger.info("相关参数缺失！！!!!");
                        return;
                    }
                    try {
                        publicSendMessageClient.processBizEvent(vo);
                        logger.info("发送消息成功=====================");
                    } catch (Exception e) {
                        e.printStackTrace();
                        logger.error("发送消息失败=====================", e);
                    }
                }
            }
        }
    }
}
