/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: QuestionLibraryClient
 * Author:   phone
 * Date:     2018/3/21 14:48
 * Description: 题库管理端
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.feign;

import com.yizhi.exam.application.vo.domain.QuestionLibrary;
import com.yizhi.exam.application.vo.ContextAndPageSizeVO;
import com.yizhi.exam.application.vo.QuestionLibraryVO;
import com.yizhi.exam.application.vo.TypeAndCountVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 〈一句话功能简述〉<br> 
 * 〈题库管理端〉
 *
 * @author fanchunhui
 * @create 2018/3/21
 * @since 1.0.0
 */
@FeignClient(name = "exam", contextId = "QuestionLibraryClient")
public interface QuestionLibraryClient {

    @GetMapping(value = "/manage/question/delete")
    Boolean delete(@RequestParam("id") Long id);

    @GetMapping(value = "/manage/question/deletes")
    boolean batchDelete(@RequestParam("ids")Long[] ids);

    @PostMapping(value = "/manage/question/exam/file/import")
    boolean insertByFile(@RequestParam("fileDir")String fileDir,@RequestParam("fileName") String fileName, @RequestParam("id")Long id);

    @PostMapping(value = "/manage/question/exam/deletes")
    boolean batchExamDelete(@RequestBody List<Long> ids);

    @GetMapping("/manage/question/list")
    Map<String,Object> list( @RequestBody ContextAndPageSizeVO contextAndPageSizeVO);

    @PostMapping("/manage/question/insert")
    boolean insert(@RequestBody QuestionLibraryVO questionLibraryVO);

    @PostMapping("/manage/question/update")
    boolean update(@RequestBody QuestionLibraryVO questionLibraryVO);

    @GetMapping("/manage/question/get/id")
    Long getQuestionLibraryId();

    @GetMapping("/manage/question/get/questionLibrary")
    QuestionLibraryVO selectQuestionLibraryById(@RequestParam(name = "id")Long id);

    @GetMapping("/manage/question/name/exist")
    QuestionLibrary nameIsExist(@RequestParam("name") String name);

    @GetMapping("/manage/question/library/type/count")
    List<TypeAndCountVo> getTypeAndCount(
            @RequestParam(name = "examId" ,required = false) Long examId,
            @RequestParam(name = "libraryId" , required = false) Long libraryId);

}