package com.yizhi.exam.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(value = "ExamImportVO", description = "")
@Data
public class ExamImportVO {

	@ApiModelProperty(value = "ID主键")
	private Long id;

	@ApiModelProperty(value = "题库名称，最多可输入20个汉字")
	private String name;

	@ApiModelProperty(value = "标签，如：金融，保险等（允许为空）可设置标签，最多设置5个，只支持文本，最多输入10个汉字。")
	private String questionLabel;

	@ApiModelProperty(value = "备注")
	private String comments;

	@ApiModelProperty(value = "题库_ID主键，外键")
	private Long libraryId;

	@ApiModelProperty(value = "题干，题目内容")
	private String stem;

	@ApiModelProperty(value = "题型值，1单选题、2多选题、3判断题、4问答题")
	private Integer type;

	@ApiModelProperty(value = "题型名称，1单选题、2多选题、3判断题、4问答题")
	private String typeValue;

	@ApiModelProperty(value = "题目解析，只支持文本")
	private String analysis;

	@ApiModelProperty(value = "题目主键_ID，外键")
	private Long subjectId;

	@ApiModelProperty(value = "选项内容，存放文字、图片、音频、视频")
	private String content1;

	@ApiModelProperty(value = "选项内容，存放文字、图片、音频、视频")
	private String content2;

	@ApiModelProperty(value = "选项内容，存放文字、图片、音频、视频")
	private String content3;

	@ApiModelProperty(value = "选项内容，存放文字、图片、音频、视频")
	private String content4;

	@ApiModelProperty(value = "正确答案，0否 1是，默认0")
	private String isAnswer;

	@ApiModelProperty(value = "选项附件路径，图片、音频、视频存放路径")
	private String optionAppendixUrl;
}
