/**
 * Copyright (C), 2015-2018, XXX有限公司
 * FileName: MyExamParameterVO
 * Author:   phone
 * Date:     2018/3/26 14:41
 * Description: 我的考试接收参数
 * History:
 * <author>          <time>          <version>          <desc>
 * 作者姓名           修改时间           版本号              描述
 */
package com.yizhi.exam.application.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 〈一句话功能简述〉<br> 
 * 〈我的考试接收参数〉
 *
 * @author phone
 * @create 2018/3/26
 * @since 1.0.0
 */
@ApiModel(value = "MyExamParamterVO", description = "我的考试接收参数VO")
@Data
public class MyExamParameterVO {

    @ApiModelProperty(value = "考试状态 0: 未开始(考试已上架，但未到考试时间) " +
                                      "1：进行中(考试时间范围内，未参加，或有考试次数，或未审阅)" +
                                      "2：已完成(考试时间内，不能再考，考试时间外已考过的所有考试) 默认是0"+
                                      "3: 已逾期(考试时间外没有考过的所有考试)")
    private Integer state = null;

    @ApiModelProperty(value = "分页参数一页显示多少条 默认10条")
    private Integer pageSize = 10;

    @ApiModelProperty(value = "页码：从第几页开始 默认为1")
    private Integer pageNo = 1;

    @ApiModelProperty(value = "考试ID")
    private Long examId;
    
    @ApiModelProperty(value = "用户ID")
    private Long accountId;

    @ApiModelProperty("用户关联ID")
    private List<Long> ids;

    @ApiModelProperty("站点ID")
    private Long siteId;

}