package com.yizhi.exam.application.vo.exam;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 试卷试题，用于生成试卷用
 * @author mei
 * @create 2018/3/14
 */
@ApiModel(value = "ExamPaperVO", description = "试卷试题，用于生成试卷用")
public class ExamPaperVO implements Serializable{

	private static final long serialVersionUID = -28941195500514351L;
	
	/*@ApiModelProperty(value = "全局唯一(Key值，用于从缓存中获取数据)")
	private String examPaperId;*/

	@ApiModelProperty(value = "考试ID")
	private Long examId;
	
	@ApiModelProperty(value = "出题策略，1手动出题 2系统出题")
	private Integer makeStrategy;

	@ApiModelProperty(value = "系统出题_出题策略，1手动出题（每个学员使用同一份试卷） 2系统出题（每个学员使用不同试卷）")
	private Integer sysMakeStrategy;
	
	@ApiModelProperty(value = "题干排序，1默认排序 2题型排序(已废弃,现加了单独按题型排序) 3随机排序")
	private Integer stemSort;
	
	@ApiModelProperty(value = "题型排序:1默认排序 2随机排序")
	private Integer typeSort;
	
	@ApiModelProperty(value = "选项排序，1默认排序 2随机排序")
	private Integer optionSort;
	
	@ApiModelProperty(value = "呈现样式，1整页呈现 2逐题呈现")
	private Integer pageMode;
	
	@ApiModelProperty(value = "答卷时长，0无限制 >0有限制(分钟)")
	private Integer duration;
	
	@ApiModelProperty(value = "考试次数，0无限制 >0有限次(次)")
	private Integer answerNum;
	
	//@ApiModelProperty(value = "考试次数，允许考试参加的次数")
	//private Integer examNum;
	
	@ApiModelProperty(value = "合格分，本次考试的合格分")
	private Integer qualifiedScore;
	
	@ApiModelProperty(value = "题型排序策略")
	private List<ExamQuestionSortVO> examQuestionSorts;
	
	@ApiModelProperty(value = "系统出题规则（出题策略：为2时获取）")
	List<QuestionOptionSystemListVO> questionSystemOptions;
	
	@ApiModelProperty(value = "必答试题")
	List<QuestionListVO> questions;
	
	@ApiModelProperty(value = "题库试题（出题策略：为2时获取）")
	Map<String, List<QuestionListVO>> libQuestions;

	@ApiModelProperty(value = "考试终端类型：1微信 2PC 3APP")
	Integer terminalType;

	@ApiModelProperty(value = "企业ID")
	Long companyId;

	@ApiModelProperty(value = "站点ID")
	Long siteId;

	@ApiModelProperty(value = "用户姓名")
	String accountName;

	@ApiModelProperty(value = "部门ID")
	Long orgId;

	@ApiModelProperty(value = "用户ID")
	Long accountId;

	@ApiModelProperty(value = "当前页")
	Integer pageNo;

	@ApiModelProperty("答卷ID")
	Long answerId;

	@ApiModelProperty("培训项目关联ID,在培训项目中发起投票,保存对应关系")
	Long trainingProjectId;
	
	public Long getAnswerId() {
		return answerId;
	}

	public void setAnswerId(Long answerId) {
		this.answerId = answerId;
	}

	@ApiModelProperty(value = "一页显示的数量")
	Integer pageSize;

	public Integer getPageNo() {
		return pageNo;
	}

	public void setPageNo(Integer pageNo) {
		this.pageNo = pageNo;
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	public Long getExamId() {
		return examId;
	}

	public void setExamId(Long examId) {
		this.examId = examId;
	}

	public Integer getMakeStrategy() {
		return makeStrategy;
	}

	public void setMakeStrategy(Integer makeStrategy) {
		this.makeStrategy = makeStrategy;
	}

	public Integer getSysMakeStrategy() {
		return sysMakeStrategy;
	}

	public void setSysMakeStrategy(Integer sysMakeStrategy) {
		this.sysMakeStrategy = sysMakeStrategy;
	}

	public Integer getStemSort() {
		return stemSort;
	}

	public void setStemSort(Integer stemSort) {
		this.stemSort = stemSort;
	}

	public Integer getOptionSort() {
		return optionSort;
	}

	public void setOptionSort(Integer optionSort) {
		this.optionSort = optionSort;
	}

	public Integer getPageMode() {
		return pageMode;
	}

	public void setPageMode(Integer pageMode) {
		this.pageMode = pageMode;
	}

	public Integer getDuration() {
		return duration;
	}

	public void setDuration(Integer duration) {
		this.duration = duration;
	}

	public Integer getAnswerNum() {
		return answerNum;
	}

	public void setAnswerNum(Integer answerNum) {
		this.answerNum = answerNum;
	}

	public Integer getQualifiedScore() {
		return qualifiedScore;
	}

	public void setQualifiedScore(Integer qualifiedScore) {
		this.qualifiedScore = qualifiedScore;
	}

	public List<ExamQuestionSortVO> getExamQuestionSorts() {
		return examQuestionSorts;
	}

	public void setExamQuestionSorts(List<ExamQuestionSortVO> examQuestionSorts) {
		this.examQuestionSorts = examQuestionSorts;
	}

	public List<QuestionOptionSystemListVO> getQuestionSystemOptions() {
		return questionSystemOptions;
	}

	public void setQuestionSystemOptions(List<QuestionOptionSystemListVO> questionSystemOptions) {
		this.questionSystemOptions = questionSystemOptions;
	}

	public List<QuestionListVO> getQuestions() {
		return questions;
	}

	public void setQuestions(List<QuestionListVO> questions) {
		this.questions = questions;
	}

	public Map<String, List<QuestionListVO>> getLibQuestions() {
		return libQuestions;
	}

	public void setLibQuestions(Map<String, List<QuestionListVO>> libQuestions) {
		this.libQuestions = libQuestions;
	}

	public Integer getTerminalType() {
		return terminalType;
	}

	public void setTerminalType(Integer terminalType) {
		this.terminalType = terminalType;
	}

	public Long getCompanyId() {
		return companyId;
	}

	public void setCompanyId(Long companyId) {
		this.companyId = companyId;
	}

	public Long getSiteId() {
		return siteId;
	}

	public void setSiteId(Long siteId) {
		this.siteId = siteId;
	}

	public String getAccountName() {
		return accountName;
	}

	public void setAccountName(String accountName) {
		this.accountName = accountName;
	}

	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public Long getAccountId() {
		return accountId;
	}

	public void setAccountId(Long accountId) {
		this.accountId = accountId;
	}

	public Long getTrainingProjectId() {
		return trainingProjectId;
	}

	public void setTrainingProjectId(Long trainingProjectId) {
		this.trainingProjectId = trainingProjectId;
	}

	public Integer getTypeSort() {
		return typeSort;
	}

	public void setTypeSort(Integer typeSort) {
		this.typeSort = typeSort;
	}
	
}
